/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.components.aggregate.TSAggregator;
import jams.components.indices.StandardPrecipitationIndex;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;
import java.util.ArrayList;
import java.util.Arrays;

@JAMSComponentDescription(title="SPICalc", author="Sven Kralisch", description="Description", date="YYYY-MM-DD", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Some improvements")})
public class SPICalc
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The list with stored values")
    public Attribute.Object valueList;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="The list to store the values")
    public Attribute.Object dateList;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Number months for SPI aggregation")
    public Attribute.Integer[] aggrMonths;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="SPI (monthly)")
    public Attribute.DoubleArray[] spiArray;

    public void run() {
        ArrayList dates = (ArrayList)this.dateList.getValue();
        ArrayList values = (ArrayList)this.valueList.getValue();
        double[] array = new double[values.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (Double)values.get(i);
        }
        TSAggregator aggr = new TSAggregator(array, dates, 0);
        TSAggregator.Aggregate aggrResult = aggr.toMonthly();
        double[] a = aggrResult.values;
        StandardPrecipitationIndex.MISSING_DATA_VALUE = Double.NaN;
        for (int i = 0; i < this.aggrMonths.length; ++i) {
            double[] spiArray = StandardPrecipitationIndex.calcSPIn(Arrays.copyOf(a, a.length), this.aggrMonths[i].getValue());
            this.round(spiArray);
            this.spiArray[i].setValue(spiArray);
        }
    }

    private void round(double[] a) {
        for (int n = 0; n < a.length; ++n) {
            a[n] = (double)Math.round(a[n] * 100.0) / 100.0;
        }
    }
}

