/*
 * Decompiled with CFR 0.152.
 */
package jams.components.indices;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;

@JAMSComponentDescription(title="KlimaKennwerte", author="Christian Fischer", description="Calculated standard Klimakennwerte for J2000Klima")
public class ClimateIndices
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily min temperatur", unit="\u00b0C")
    public Attribute.Double tmin;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily mean temperatur", unit="\u00b0C")
    public Attribute.Double tmean;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily max temperatur", unit="\u00b0C")
    public Attribute.Double tmax;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily precipitation", unit="L")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily windspeed", unit="m/s")
    public Attribute.Double wind;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="relative humidity", unit="-")
    public Attribute.Double relHum;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="daily pot. evapotranspiration", unit="L")
    public Attribute.Double potET;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="size of hru", unit="m\u00b2")
    public Attribute.Double area;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="1 if day is attractive for tourists (temp higher 15 and lower than 30 and precip < 0.5mm)")
    public Attribute.Double isTouristDay;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if we are in the thermal vegetation period")
    public Attribute.Double isThermalVegetationPeriodTrigger;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if we are in the thermal vegetation period\nDefintion: first day = Sum of Tmean in last 30days is larger than 150\n last day = Sum of Tmean in last 30days is less than 150")
    public Attribute.Double isThermalVegetationPeriodTrigger2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if we are in the forest vegetation period")
    public Attribute.Double isForestVegetationPeriodTrigger;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if a dry period has started")
    public Attribute.Double isBeginningOfDryPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if we are within a dry period")
    public Attribute.Double isDryPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if more than 20mm precip did occur")
    public Attribute.Double isPrecipHigher20mm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if more than 30mm precip did occur")
    public Attribute.Double isPrecipHigher30mm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if more than 40mm precip did occur")
    public Attribute.Double isPrecipHigher40mm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="calculates if more than 50mm precip did occur")
    public Attribute.Double isPrecipHigher50mm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="calculates the number of successive days where precip is zero")
    public Attribute.Double successiveDaysWithoutRain;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="calculates if windspeed is higher than 28m/s")
    public Attribute.Double isHeavyStorm;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="calculates if windspeed is between 8 and 18m/s")
    public Attribute.Double isProductiveWindday;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="calculates the climatic water balance (P-potET)")
    public Attribute.Double KWB;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="calculates the climatic water balance (P-potET) during thermal vegetation period")
    public Attribute.Double KWBinThermalVegetationPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="calculates the climatic water balance (P-potET) during thermal vegetation period (see thermal vegetation period2)")
    public Attribute.Double KWBinThermalVegetationPeriod2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="calculates the klimatische wasserbilanz (P-potET) during forstlicher vegetation period")
    public Attribute.Double KWBinForestVegetationPeriod;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="tmp variables")
    public Attribute.DoubleArray tmp;
    private final int INDEX_successiveDaysWithTmeanAboveFiveDegree = 0;
    private final int INDEX_successiveDaysWithTmeanAboveTenDegree = 1;
    private final int INDEX_successiveDaysWithTmeanBelowFiveDegree = 2;
    private final int INDEX_successiveDaysWithTmeanBelowTenDegree = 3;
    private final int INDEX_KWB_in_thermal_vegetation_period = 4;
    private final int INDEX_KWB_in_forest_vegetation_period = 5;
    private final int INDEX_KWB_in_thermal_vegetation_period2 = 6;
    private final int INDEX_SUMMERINDEX = 7;
    private final int INDEX_WINTERINDEX = 8;
    private final int INDEX_KWB_window_position = 9;
    private final int INDEX_KWB_window = 10;
    private final int KWB_WINDOW_SIZE = 30;
    private final int INDEX_SIZE = 40;

    public void run() {
        int day = this.time.get(6);
        double tmean = this.tmean.getValue();
        this.isDryPeriod.setValue(0.0);
        this.isBeginningOfDryPeriod.setValue(0.0);
        this.isPrecipHigher20mm.setValue(0.0);
        this.isPrecipHigher30mm.setValue(0.0);
        this.isPrecipHigher40mm.setValue(0.0);
        this.isPrecipHigher50mm.setValue(0.0);
        this.isHeavyStorm.setValue(0.0);
        this.isProductiveWindday.setValue(0.0);
        this.isTouristDay.setValue(0.0);
        if (this.tmp.getValue() == null) {
            this.tmp.setValue(new double[40]);
        }
        double[] inTmp = this.tmp.getValue();
        if (tmean > 5.0) {
            inTmp[0] = inTmp[0] + 1.0;
            inTmp[2] = 0.0;
        } else {
            inTmp[2] = inTmp[2] + 1.0;
            inTmp[0] = 0.0;
        }
        if (tmean > 10.0) {
            inTmp[1] = inTmp[1] + 1.0;
            inTmp[3] = 0.0;
        } else {
            inTmp[1] = 0.0;
            inTmp[3] = inTmp[3] + 1.0;
        }
        if (inTmp[0] >= 6.0) {
            this.isThermalVegetationPeriodTrigger.setValue(1.0);
        } else if (inTmp[2] < 6.0 && day > 180) {
            this.isThermalVegetationPeriodTrigger.setValue(0.0);
        }
        if (inTmp[1] >= 6.0) {
            this.isForestVegetationPeriodTrigger.setValue(1.0);
        } else if (inTmp[3] >= 6.0 && day > 180) {
            this.isForestVegetationPeriodTrigger.setValue(0.0);
        }
        int p = (int)inTmp[9];
        inTmp[10 + p] = tmean;
        p = (p + 1) % 30;
        double tSum = 0.0;
        for (int i = 0; i < 30; ++i) {
            tSum += inTmp[9 + i];
        }
        if (tSum > 150.0 && inTmp[10 + p] > 5.0) {
            this.isThermalVegetationPeriodTrigger2.setValue(1.0);
        } else if (tSum < 150.0 && inTmp[10 + p] < 5.0 && day > 180) {
            this.isThermalVegetationPeriodTrigger2.setValue(0.0);
        }
        inTmp[9] = p;
        if (this.precip != null) {
            double precip_mm = this.precip.getValue() / this.area.getValue();
            if (precip_mm >= 20.0) {
                this.isPrecipHigher20mm.setValue(1.0);
            }
            if (precip_mm >= 30.0) {
                this.isPrecipHigher30mm.setValue(1.0);
            }
            if (precip_mm >= 40.0) {
                this.isPrecipHigher40mm.setValue(1.0);
            }
            if (precip_mm >= 50.0) {
                this.isPrecipHigher50mm.setValue(1.0);
            }
            if (precip_mm < 0.1) {
                this.successiveDaysWithoutRain.setValue(this.successiveDaysWithoutRain.getValue() + 1.0);
                if (this.successiveDaysWithoutRain.getValue() == 11.0) {
                    this.isDryPeriod.setValue(11.0);
                    this.isBeginningOfDryPeriod.setValue(1.0);
                } else if (this.successiveDaysWithoutRain.getValue() > 11.0) {
                    this.isDryPeriod.setValue(1.0);
                }
            } else {
                this.successiveDaysWithoutRain.setValue(0.0);
            }
            if (tmean >= 15.0 && tmean <= 30.0 && precip_mm < 0.5) {
                this.isTouristDay.setValue(1.0);
            }
        }
        if (this.wind != null) {
            if (this.wind.getValue() >= 28.0) {
                this.isHeavyStorm.setValue(1.0);
            }
            if (this.wind.getValue() >= 8.0 && this.wind.getValue() <= 18.0) {
                this.isProductiveWindday.setValue(1.0);
            }
        }
        if (this.potET != null && this.precip != null) {
            double KWB_mm = this.precip.getValue() - this.potET.getValue();
            this.KWB.setValue(KWB_mm);
            inTmp[4] = inTmp[4] + KWB_mm;
            inTmp[5] = inTmp[5] + KWB_mm;
            inTmp[6] = inTmp[6] + KWB_mm;
            if (this.isThermalVegetationPeriodTrigger.getValue() == 1.0) {
                this.KWBinThermalVegetationPeriod.setValue(this.KWBinThermalVegetationPeriod.getValue() + inTmp[4]);
                inTmp[4] = 0.0;
            }
            if (this.isForestVegetationPeriodTrigger.getValue() == 1.0) {
                this.KWBinForestVegetationPeriod.setValue(this.KWBinForestVegetationPeriod.getValue() + inTmp[5]);
                inTmp[5] = 0.0;
            }
            if (this.isThermalVegetationPeriodTrigger2.getValue() == 1.0) {
                this.KWBinThermalVegetationPeriod2.setValue(this.KWBinThermalVegetationPeriod2.getValue() + inTmp[6]);
                inTmp[6] = 0.0;
            }
        }
        if (this.time.get(6) == 1) {
            this.KWBinThermalVegetationPeriod.setValue(0.0);
            this.KWBinThermalVegetationPeriod2.setValue(0.0);
            this.KWBinForestVegetationPeriod.setValue(0.0);
            inTmp[6] = 0.0;
            inTmp[5] = 0.0;
            inTmp[5] = 0.0;
            inTmp[7] = -1.0;
        }
        if (this.time.get(6) == 180) {
            inTmp[8] = -1.0;
        }
    }
}

