/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.CTSPlot;
import jams.components.gui.spreadsheet.GraphProperties;
import jams.components.gui.spreadsheet.JAMSXYPlot;
import jams.components.gui.spreadsheet.XYRow;
import jams.tools.JAMSTools;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EtchedBorder;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.chart.renderer.xy.XYBarRenderer;
import org.jfree.chart.renderer.xy.XYDifferenceRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.renderer.xy.XYStepAreaRenderer;
import org.jfree.chart.renderer.xy.XYStepRenderer;

public class JXYConfigurator
extends JFrame {
    GroupLayout gLayout;
    GroupLayout.SequentialGroup hGroup;
    GroupLayout.SequentialGroup vGroup;
    GroupLayout.Group group1;
    GroupLayout.Group group2;
    GroupLayout.Group group3;
    GroupLayout.Group group4;
    GroupLayout.Group group5;
    GroupLayout.Group group6;
    GroupLayout.Group group7;
    GroupLayout.Group group8;
    GroupLayout.Group group9;
    GroupLayout.Group group10;
    GroupLayout.Group group11;
    GroupLayout.Group group12;
    GroupLayout.Group group13;
    GroupLayout.Group group14;
    GroupLayout.Group group15;
    private JFrame parent;
    private JFrame thisDlg;
    private JPanel frame;
    private JPanel mainpanel;
    private JPanel plotpanel;
    private JPanel optionpanel;
    private JPanel graphpanel;
    private JPanel southpanel;
    private JPanel edTitlePanel;
    private JPanel edLeftAxisPanel;
    private JPanel edRightAxisPanel;
    private JPanel edTimeAxisPanel;
    private JSplitPane split_hor = new JSplitPane(1);
    private JSplitPane split_vert = new JSplitPane(0);
    private JPanel[] datapanels;
    private JScrollPane graphScPane;
    private JScrollPane plotScPane;
    private JScrollPane mainScPane;
    private JScrollPane optScPane;
    private JPanel savePanel;
    private String[] headers;
    private JLabel edTitle = new JLabel("Plot Title: ");
    private JLabel edLeft = new JLabel("Left axis title: ");
    private JLabel edXAxis = new JLabel("X axis title");
    private JLabel edRight = new JLabel("Right axis title: ");
    private JLabel rLeftLabel = new JLabel("Renderer left");
    private JLabel rRightLabel = new JLabel("Renderer right");
    private JLabel invLeftLabel = new JLabel("Invert left axis");
    private JLabel invRightLabel = new JLabel("Invert right axis");
    private JTextField edTitleField = new JTextField(14);
    private JTextField edLeftField = new JTextField(14);
    private JTextField edRightField = new JTextField(14);
    private JTextField edXAxisField = new JTextField(14);
    private String[] types = new String[]{"Line and Shape", "Bar", "Area", "Step", "StepArea", "Difference"};
    private JComboBox rLeftBox = new JComboBox<String>(this.types);
    private JComboBox rRightBox = new JComboBox<String>(this.types);
    private JCheckBox invLeftBox = new JCheckBox("Invert left Axis");
    private JCheckBox invRightBox = new JCheckBox("Invert right Axis");
    private ButtonGroup isXAxisGroup = new ButtonGroup();
    private JButton applyButton = new JButton("Apply");
    private JButton addButton = new JButton("Add Graph");
    private JButton saveButton = new JButton("EPS export");
    private Vector<GraphProperties> propVector = new Vector();
    private JAMSXYPlot jxys = new JAMSXYPlot();
    public XYRow[] sorted_Row;
    private int x_series_index;
    private int colour_cnt;
    double row_start;
    double row_end;
    private boolean d_start_changed;
    private boolean d_end_changed;
    int[] range = new int[2];
    HashMap<String, Color> colorTable = new HashMap();
    int[] rows;
    int[] columns;
    JTable table;
    CTSPlot ctsplot;
    int graphCount = 0;
    JCheckBox[] activate;
    JComboBox[] datachoice;
    JComboBox[] poschoice;
    JComboBox[] typechoice;
    JComboBox[] colorchoice;
    ActionListener[] activationChange;
    ActionListener titleListener = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent te) {
            JXYConfigurator.this.ctsplot.getChart().setTitle(JXYConfigurator.this.edTitleField.getText());
        }
    };
    ActionListener propbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JXYConfigurator.this.ctsplot.getChartPanel().doEditChartProperties();
        }
    };
    ActionListener addbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JXYConfigurator.this.addGraph((GraphProperties)JXYConfigurator.this.propVector.get(0));
        }
    };
    ActionListener plotbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int[] range = JXYConfigurator.this.setPossibleDataIntervals();
            for (int i = 0; i < JXYConfigurator.this.propVector.size(); ++i) {
                GraphProperties prop = (GraphProperties)JXYConfigurator.this.propVector.get(i);
                prop.setXIntervals(range);
                prop.applyXYProperties();
            }
            JXYConfigurator.this.plotAllGraphs();
            JXYConfigurator.this.dStartChanged(false);
            JXYConfigurator.this.dEndChanged(false);
        }
    };
    ActionListener actChanged = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    };
    ActionListener saveImageAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            try {
                JFileChooser chooser = new JFileChooser();
                int returnVal = chooser.showSaveDialog(JXYConfigurator.this.thisDlg);
                File file = chooser.getSelectedFile();
                JXYConfigurator.this.jxys.saveAsEPS(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public JXYConfigurator() {
    }

    public JXYConfigurator(JFrame parent, JTable table) {
        this.parent = parent;
        this.setTitle("JAMS XYPlot Viewer");
        this.setIconImages(JAMSTools.getJAMSIcons());
        this.setLayout(new FlowLayout());
        Point parentloc = parent.getLocation();
        this.setLocation(parentloc.x + 30, parentloc.y + 30);
        this.table = table;
        this.rows = table.getSelectedRows();
        this.columns = table.getSelectedColumns();
        this.graphCount = this.columns.length;
        this.headers = new String[this.graphCount];
        this.d_start_changed = false;
        this.d_end_changed = false;
        this.writeSortedData(this.columns[0]);
        this.setSize(680, 480);
        this.createPanel();
        this.pack();
        this.setVisible(true);
    }

    public void createPanel() {
        GraphProperties prop;
        int k;
        this.thisDlg = this;
        this.colour_cnt = 0;
        this.colorTable.put("yellow", Color.yellow);
        this.colorTable.put("orange", Color.orange);
        this.colorTable.put("red", Color.red);
        this.colorTable.put("pink", Color.pink);
        this.colorTable.put("magenta", Color.magenta);
        this.colorTable.put("cyan", Color.cyan);
        this.colorTable.put("blue", Color.blue);
        this.colorTable.put("green", Color.green);
        this.colorTable.put("gray", Color.gray);
        this.colorTable.put("lightgray", Color.lightGray);
        this.colorTable.put("black", Color.black);
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Renderer");
        JLabel colorLabel = new JLabel("Colour");
        JLabel dataLabel = new JLabel("Select Data / Legend Entry");
        JLabel timeLabel = new JLabel("Data Range");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry");
        nameLabel.setBackground(Color.DARK_GRAY);
        posLabel.setBackground(Color.DARK_GRAY);
        typeLabel.setBackground(Color.DARK_GRAY);
        colorLabel.setBackground(Color.DARK_GRAY);
        dataLabel.setBackground(Color.DARK_GRAY);
        timeLabel.setBackground(Color.DARK_GRAY);
        this.saveButton.addActionListener(this.saveImageAction);
        this.savePanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.plotpanel = new JPanel();
        this.plotpanel.setLayout(new BorderLayout());
        this.frame = new JPanel();
        this.frame.setLayout(new BorderLayout());
        this.graphScPane = new JScrollPane();
        this.optionpanel = new JPanel();
        this.graphpanel = new JPanel();
        this.initGroupUI();
        this.southpanel = new JPanel();
        this.southpanel.setLayout(new FlowLayout());
        this.edTitlePanel = new JPanel();
        this.edTitlePanel.setLayout(new FlowLayout());
        this.edLeftAxisPanel = new JPanel();
        this.edLeftAxisPanel.setLayout(new FlowLayout());
        this.edRightAxisPanel = new JPanel();
        this.edRightAxisPanel.setLayout(new FlowLayout());
        this.edTitleField.setText("XY Data Plot");
        this.edTitleField.setSize(40, 10);
        this.edTitleField.addActionListener(this.plotbuttonclick);
        this.edLeftField.setText("Left Axis Title");
        this.edLeftField.addActionListener(this.plotbuttonclick);
        this.edLeftField.setSize(40, 10);
        this.edRightField.setText("Right Axis Title");
        this.edRightField.addActionListener(this.plotbuttonclick);
        this.edRightField.setSize(40, 10);
        this.edXAxisField.setText("x axis title");
        this.edXAxisField.addActionListener(this.plotbuttonclick);
        this.applyButton.addActionListener(this.plotbuttonclick);
        this.optionpanel.add(this.edTitle);
        this.optionpanel.add(this.edTitleField);
        this.optionpanel.add(this.edLeft);
        this.optionpanel.add(this.edLeftField);
        this.optionpanel.add(this.edRight);
        this.optionpanel.add(this.edRightField);
        this.optionpanel.add(this.applyButton);
        for (k = 0; k < this.graphCount; ++k) {
            prop = new GraphProperties(this);
            prop.setSelectedColumn(this.columns[k]);
            prop.setXSeries(this.columns[0]);
            prop.setSelectedRows(this.rows);
            if (k == 0) {
                prop.getIsXAxisButton().setSelected(true);
                prop.setIsXSeries(true);
                prop.getDataChoice().setEnabled(false);
                prop.getDataChoiceSTART().setEnabled(true);
                prop.getDataChoiceEND().setEnabled(true);
                prop.getColorChoice().setEnabled(false);
                prop.getPosChoice().setEnabled(false);
                prop.getLegendField().setEnabled(false);
                prop.getCustomizeButton().setEnabled(false);
                prop.getAddButton().setEnabled(false);
                prop.getRemButton().setEnabled(false);
                prop.getUpButton().setEnabled(false);
                prop.getDownButton().setEnabled(false);
            } else {
                prop.getMaxButton().setEnabled(false);
                prop.getDataChoiceSTART().setEnabled(false);
                prop.getDataChoiceEND().setEnabled(false);
            }
            prop.getAddButton().setEnabled(true);
            prop.getRemButton().setEnabled(true);
            prop.getUpButton().setEnabled(true);
            prop.getDownButton().setEnabled(true);
            int color_cnt = k < 9 ? k : 0;
            String[] colors = this.getColorScheme(color_cnt);
            prop.setSeriesPaint(this.colorTable.get(colors[0]));
            prop.setSeriesFillPaint(this.colorTable.get(colors[1]));
            prop.setSeriesOutlinePaint(this.colorTable.get(colors[2]));
            prop.setName(this.table.getColumnName(k + 1));
            prop.setLegendName(this.table.getColumnName(k + 1));
            this.propVector.add(k, prop);
        }
        this.range = this.setDataIntervals();
        for (k = 0; k < this.propVector.size(); ++k) {
            prop = this.propVector.get(k);
            prop.setXIntervals(this.range);
            if (k == this.x_series_index) {
                prop.setDataSTART(this.row_start);
                prop.setDataEND(this.row_end);
            }
            prop.applyXYProperties();
            this.addPropGroup(this.propVector.get(k));
        }
        this.finishGroupUI();
        this.createOptionPanel();
        this.handleRenderer();
        this.jxys.setPropVector(this.propVector);
        this.jxys.createPlot();
        JPanel graphPanel = new JPanel();
        JPanel optPanel = new JPanel();
        graphPanel.add(this.graphpanel);
        optPanel.add(this.optionpanel);
        this.graphScPane = new JScrollPane(graphPanel);
        this.graphScPane.setVerticalScrollBarPolicy(22);
        this.savePanel.add(this.saveButton);
        this.jxys.getPanel().add((Component)this.savePanel, "East");
        this.optionpanel.setBorder(new EtchedBorder());
        this.plotScPane = new JScrollPane(this.jxys.getPanel());
        this.optScPane = new JScrollPane(optPanel);
        this.split_hor.add((Component)this.optScPane, 0);
        this.split_hor.add((Component)this.graphScPane, 1);
        this.split_vert.add((Component)this.split_hor, 0);
        this.split_vert.add((Component)this.plotScPane, 1);
        this.add(this.split_vert);
        this.plotAllGraphs();
    }

    private void writeSortedData(int x_col) {
        int row_nr = this.table.getRowCount();
        int col_nr = this.table.getColumnCount();
        this.sorted_Row = new XYRow[row_nr];
        for (int i = 0; i < row_nr; ++i) {
            double[] rowarray = new double[col_nr];
            for (int j = 0; j < col_nr; ++j) {
                try {
                    rowarray[j] = (Double)this.table.getValueAt(i, j);
                    continue;
                }
                catch (ClassCastException cce) {
                    rowarray[j] = 0.0;
                }
            }
            this.sorted_Row[i] = new XYRow(rowarray, x_col);
        }
        Arrays.sort(this.sorted_Row);
    }

    private void resortData(int x_col) {
        for (int i = 0; i < this.sorted_Row.length; ++i) {
            this.sorted_Row[i].setCompareIndex(x_col);
        }
        Arrays.sort(this.sorted_Row);
    }

    public int[] setDataIntervals() {
        int[] range = new int[2];
        int x_column = this.propVector.get(this.x_series_index).getSelectedColumn();
        this.row_start = this.sorted_Row[0].col[x_column];
        this.row_end = this.sorted_Row[this.sorted_Row.length - 1].col[x_column];
        range[0] = 0;
        range[1] = this.sorted_Row.length - 1;
        this.dStartChanged(false);
        this.dEndChanged(false);
        return range;
    }

    public void setMaxDataIntervals(GraphProperties x_prop) {
        int[] range = new int[2];
        this.resortData(x_prop.getSelectedColumn());
        range = this.setDataIntervals();
        this.range = range;
        x_prop.setXIntervals(range);
        x_prop.setDataSTART(this.row_start);
        x_prop.setDataEND(this.row_end);
        this.dStartChanged(false);
        this.dEndChanged(false);
    }

    public void dStartChanged(boolean state) {
        this.d_start_changed = state;
    }

    public void dEndChanged(boolean state) {
        this.d_end_changed = state;
    }

    public int[] setPossibleDataIntervals() {
        int[] range = new int[2];
        GraphProperties x_prop = this.propVector.get(this.x_series_index);
        if (!this.d_start_changed || !this.d_end_changed) {
            boolean out_of_boundaries;
            int x_col;
            int i;
            double end;
            double start;
            if (!this.d_start_changed) {
                range[0] = this.range[0];
            } else {
                start = x_prop.readDataSTART();
                end = x_prop.readDataEND();
                i = 0;
                x_col = x_prop.getSelectedColumn();
                boolean bl = out_of_boundaries = start < this.sorted_Row[0].col[x_col] || start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                if (end < start) {
                    end = start;
                }
                if (!out_of_boundaries) {
                    while (!(start >= this.sorted_Row[i].col[x_col]) || !(start <= this.sorted_Row[i + 1].col[x_col])) {
                        ++i;
                    }
                    if (start == this.sorted_Row[i].col[x_col]) {
                        start = this.sorted_Row[i].col[x_col];
                        range[0] = i;
                    } else {
                        start = this.sorted_Row[i + 1].col[x_col];
                        range[0] = i + 1;
                    }
                } else {
                    if (start < this.sorted_Row[0].col[x_col]) {
                        start = this.sorted_Row[0].col[x_col];
                        range[0] = 0;
                    }
                    if (start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                        start = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                        range[0] = this.sorted_Row.length - 1;
                    }
                }
                this.row_start = start;
            }
            if (!this.d_end_changed) {
                range[1] = this.range[1];
            } else {
                start = x_prop.readDataSTART();
                end = x_prop.readDataEND();
                i = 0;
                x_col = x_prop.getSelectedColumn();
                boolean bl = out_of_boundaries = end < this.sorted_Row[0].col[x_col] || end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                if (!out_of_boundaries) {
                    while (!(end >= this.sorted_Row[i].col[x_col]) || !(end <= this.sorted_Row[i + 1].col[x_col])) {
                        ++i;
                    }
                    if (end == this.sorted_Row[i + 1].col[x_col]) {
                        end = this.sorted_Row[i + 1].col[x_col];
                        range[1] = i + 1;
                    } else {
                        end = this.sorted_Row[i].col[x_col];
                        range[1] = i;
                    }
                } else {
                    if (end < this.sorted_Row[0].col[x_col]) {
                        end = this.sorted_Row[0].col[x_col];
                        range[1] = 0;
                    }
                    if (end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                        end = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                        range[1] = this.sorted_Row.length - 1;
                    }
                }
                this.row_end = end;
            }
        } else {
            boolean out_of_boundaries;
            double start = x_prop.readDataSTART();
            double end = x_prop.readDataEND();
            int i = 0;
            int x_col = x_prop.getSelectedColumn();
            boolean bl = out_of_boundaries = start < this.sorted_Row[0].col[x_col] || start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
            if (end < start) {
                end = start;
            }
            if (!out_of_boundaries) {
                while (!(start >= this.sorted_Row[i].col[x_col]) || !(start <= this.sorted_Row[i + 1].col[x_col])) {
                    ++i;
                }
                if (start == this.sorted_Row[i].col[x_col]) {
                    start = this.sorted_Row[i].col[x_col];
                    range[0] = i;
                } else {
                    start = this.sorted_Row[i + 1].col[x_col];
                    range[0] = i + 1;
                }
            } else {
                if (start < this.sorted_Row[0].col[x_col]) {
                    start = this.sorted_Row[0].col[x_col];
                    range[0] = 0;
                }
                if (start > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                    start = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                    range[0] = this.sorted_Row.length - 1;
                }
            }
            boolean bl2 = out_of_boundaries = end < this.sorted_Row[0].col[x_col] || end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
            if (!out_of_boundaries) {
                while (!(end >= this.sorted_Row[i].col[x_col]) || !(end <= this.sorted_Row[i + 1].col[x_col])) {
                    ++i;
                }
                if (end == this.sorted_Row[i + 1].col[x_col]) {
                    end = this.sorted_Row[i + 1].col[x_col];
                    range[1] = i + 1;
                } else {
                    end = this.sorted_Row[i].col[x_col];
                    range[1] = i;
                }
            } else {
                if (end < this.sorted_Row[0].col[x_col]) {
                    end = this.sorted_Row[0].col[x_col];
                    range[1] = 0;
                }
                if (end > this.sorted_Row[this.sorted_Row.length - 1].col[x_col]) {
                    end = this.sorted_Row[this.sorted_Row.length - 1].col[x_col];
                    range[1] = this.sorted_Row.length - 1;
                }
            }
            this.row_start = start;
            this.row_end = end;
        }
        this.range = range;
        return range;
    }

    private String[] getColorScheme(int scheme) {
        String[] colors = new String[3];
        switch (scheme) {
            case 0: {
                colors[0] = "red";
                colors[1] = "red";
                colors[2] = "gray";
                break;
            }
            case 1: {
                colors[0] = "blue";
                colors[1] = "blue";
                colors[2] = "black";
                break;
            }
            case 2: {
                colors[0] = "green";
                colors[1] = "green";
                colors[2] = "gray";
                break;
            }
            case 3: {
                colors[0] = "black";
                colors[1] = "black";
                colors[2] = "yellow";
                break;
            }
            case 4: {
                colors[0] = "orange";
                colors[1] = "orange";
                colors[2] = "cyan";
                break;
            }
            case 5: {
                colors[0] = "cyan";
                colors[1] = "cyan";
                colors[2] = "black";
                break;
            }
            case 6: {
                colors[0] = "magenta";
                colors[1] = "yellow";
                colors[2] = "magenta";
                break;
            }
            case 7: {
                colors[0] = "lightgray";
                colors[1] = "orange";
                colors[2] = "lightgray";
                break;
            }
            default: {
                colors[0] = "red";
                colors[1] = "blue";
                colors[2] = "red";
            }
        }
        return colors;
    }

    public void addGraph(GraphProperties prop) {
        AddGraphDlg dlg = new AddGraphDlg();
        dlg.setVisible(true);
        if (dlg.getResult()) {
            int i = this.propVector.indexOf(prop);
            GraphProperties newProp = new GraphProperties(this);
            ++this.colour_cnt;
            newProp.setPosition(dlg.getSide());
            i = dlg.getPosition();
            dlg.dispose();
            newProp.getDataChoice().setSelectedIndex(1);
            newProp.setSeriesPaint(this.colorTable.get(this.getColorScheme(i)[0]));
            newProp.setSeriesFillPaint(this.colorTable.get(this.getColorScheme(i)[1]));
            newProp.setSeriesOutlinePaint(this.colorTable.get(this.getColorScheme(i)[2]));
            if (i > 0) {
                double d_start = prop.getDataSTART();
                double d_end = prop.getDataEND();
                newProp.setDataSTART(d_start);
                newProp.setDataEND(d_end);
                newProp.getDataChoiceSTART().setEnabled(false);
                newProp.getDataChoiceEND().setEnabled(false);
                newProp.getMaxButton().setEnabled(false);
            }
            this.propVector.add(i, newProp);
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            this.handleRenderer();
            for (int k = 0; k < this.graphCount; ++k) {
                newProp = this.propVector.get(k);
                newProp.setIndex(k);
                if (newProp.isXSeries()) {
                    this.x_series_index = k;
                }
                this.addPropGroup(newProp);
            }
            this.xChanged(this.propVector.get(this.x_series_index));
            this.setMaxDataIntervals(this.propVector.get(this.x_series_index));
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void removeGraph(GraphProperties prop) {
        if (this.graphCount > 1) {
            this.propVector.remove(this.propVector.indexOf(prop));
            this.graphCount = this.propVector.size();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties newProp = this.propVector.get(k);
                if (newProp.isXSeries()) {
                    this.x_series_index = k;
                }
                this.addPropGroup(newProp);
            }
            this.xChanged(this.propVector.get(this.x_series_index));
            this.setMaxDataIntervals(this.propVector.get(this.x_series_index));
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void upGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        boolean xChanged = false;
        if (i - 1 >= 0 && i - 1 < this.graphCount) {
            this.propVector.remove(prop);
            this.propVector.add(i - 1, prop);
            this.handleRenderer();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties newProp = this.propVector.get(k);
                if (newProp.isXSeries()) {
                    this.x_series_index = k;
                    xChanged = true;
                }
                this.addPropGroup(newProp);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    public void downGraph(GraphProperties prop) {
        int i = this.propVector.indexOf(prop);
        boolean xChanged = false;
        if (i < this.propVector.size() && i + 1 >= 0 && i + 1 < this.graphCount) {
            this.propVector.remove(prop);
            this.propVector.add(i + 1, prop);
            this.graphCount = this.propVector.size();
            this.handleRenderer();
            this.initGroupUI();
            for (int k = 0; k < this.graphCount; ++k) {
                GraphProperties newProp = this.propVector.get(k);
                if (prop.isXSeries()) {
                    this.x_series_index = k;
                    xChanged = true;
                }
                this.addPropGroup(newProp);
            }
            this.finishGroupUI();
            this.repaint();
        }
    }

    private void updatePropVector() {
        for (int i = 0; i < this.propVector.size(); ++i) {
            this.propVector.get(i).applyXYProperties();
        }
    }

    public int getRendererLeft() {
        return this.rLeftBox.getSelectedIndex();
    }

    public int getRendererRight() {
        return this.rRightBox.getSelectedIndex();
    }

    public void xChanged(GraphProperties prop) {
        int index;
        this.x_series_index = index = this.propVector.indexOf(prop);
        this.dStartChanged(true);
        this.dEndChanged(true);
        for (int i = 0; i < this.propVector.size(); ++i) {
            if (i == index) continue;
            this.propVector.get(i).setXSeries(this.propVector.get(this.x_series_index).getSelectedColumn());
            this.propVector.get(i).setXChanged(true);
            this.propVector.get(i).setIsXSeries(false);
            this.propVector.get(i).getDataChoice().setEnabled(true);
            this.propVector.get(i).getDataChoiceSTART().setEnabled(false);
            this.propVector.get(i).getDataChoiceEND().setEnabled(false);
            this.propVector.get(i).getColorChoice().setEnabled(true);
            this.propVector.get(i).getPosChoice().setEnabled(true);
            this.propVector.get(i).getAddButton().setEnabled(true);
            this.propVector.get(i).getRemButton().setEnabled(true);
            this.propVector.get(i).getUpButton().setEnabled(true);
            this.propVector.get(i).getDownButton().setEnabled(true);
            this.propVector.get(i).getLegendField().setEnabled(true);
            this.propVector.get(i).getCustomizeButton().setEnabled(true);
            this.propVector.get(i).getMaxButton().setEnabled(false);
        }
        prop.setXChanged(true);
        prop.setIsXSeries(true);
        prop.getIsXAxisButton().setEnabled(true);
        prop.setXSeries(prop.getSelectedColumn());
        prop.getDataChoice().setEnabled(false);
        prop.getDataChoiceSTART().setEnabled(true);
        prop.getDataChoiceEND().setEnabled(true);
        prop.getColorChoice().setEnabled(false);
        prop.getPosChoice().setEnabled(false);
        prop.getAddButton().setEnabled(false);
        prop.getRemButton().setEnabled(false);
        prop.getUpButton().setEnabled(false);
        prop.getDownButton().setEnabled(false);
        prop.getLegendField().setEnabled(false);
        prop.getCustomizeButton().setEnabled(false);
        prop.getMaxButton().setEnabled(true);
    }

    public void plotAllGraphs() {
        this.updatePropVector();
        int l = 0;
        int r = 0;
        int corr = 0;
        int rLeft = this.rLeftBox.getSelectedIndex();
        int rRight = this.rRightBox.getSelectedIndex();
        XYLineAndShapeRenderer rendererLeft = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer rendererRight = new XYLineAndShapeRenderer();
        XYLineAndShapeRenderer lsr_R = new XYLineAndShapeRenderer();
        XYBarRenderer brr_R = new XYBarRenderer();
        XYDifferenceRenderer dfr_R = new XYDifferenceRenderer();
        XYAreaRenderer ar_R = new XYAreaRenderer();
        XYStepRenderer str_R = new XYStepRenderer();
        XYStepAreaRenderer sar_R = new XYStepAreaRenderer();
        XYLineAndShapeRenderer lsr_L = new XYLineAndShapeRenderer();
        XYBarRenderer brr_L = new XYBarRenderer();
        XYDifferenceRenderer dfr_L = new XYDifferenceRenderer();
        XYAreaRenderer ar_L = new XYAreaRenderer();
        XYStepRenderer str_L = new XYStepRenderer();
        XYStepAreaRenderer sar_L = new XYStepAreaRenderer();
        block16: for (int i = 0; i < this.propVector.size(); ++i) {
            GraphProperties prop = this.propVector.get(i);
            if (prop.getPosChoice().getSelectedItem() == "left") {
                if (!this.propVector.get(i).isXSeries()) {
                    ++l;
                    switch (rLeft) {
                        case 0: {
                            lsr_L.setSeriesPaint(i - r - corr, (Paint)prop.getSeriesPaint());
                            lsr_L.setSeriesStroke(i - r - corr, prop.getSeriesStroke());
                            lsr_L.setSeriesShape(i - r - corr, prop.getSeriesShape());
                            lsr_L.setSeriesShapesVisible(i - r - corr, prop.getShapesVisible());
                            lsr_L.setSeriesLinesVisible(i - r - corr, prop.getLinesVisible());
                            lsr_L.setUseOutlinePaint(true);
                            lsr_L.setSeriesFillPaint(i - r - corr, (Paint)prop.getSeriesFillPaint());
                            lsr_L.setUseFillPaint(true);
                            lsr_L.setSeriesOutlineStroke(i - r - corr, prop.getSeriesOutlineStroke());
                            lsr_L.setSeriesOutlinePaint(i - r - corr, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = lsr_L;
                            break;
                        }
                        case 1: {
                            brr_L.setSeriesPaint(i - r - corr, (Paint)prop.getSeriesPaint());
                            brr_L.setSeriesStroke(i - r - corr, prop.getSeriesStroke());
                            brr_L.setSeriesOutlineStroke(i - r - corr, prop.getSeriesOutlineStroke());
                            brr_L.setSeriesOutlinePaint(i - r - corr, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = brr_L;
                            break;
                        }
                        case 2: {
                            ar_L.setSeriesPaint(i - r - corr, (Paint)prop.getSeriesPaint());
                            ar_L.setSeriesStroke(i - r - corr, prop.getSeriesStroke());
                            ar_L.setSeriesShape(i - r - corr, prop.getSeriesShape());
                            ar_L.setSeriesOutlineStroke(i - r - corr, prop.getSeriesOutlineStroke());
                            ar_L.setSeriesOutlinePaint(i - r - corr, (Paint)prop.getSeriesOutlinePaint());
                            ar_L.setOutline(prop.getOutlineVisible());
                            rendererLeft = ar_L;
                            break;
                        }
                        case 3: {
                            str_L.setSeriesPaint(i - r - corr, (Paint)prop.getSeriesPaint());
                            str_L.setSeriesStroke(i - r - corr, prop.getSeriesStroke());
                            str_L.setSeriesShape(i - r - corr, prop.getSeriesShape());
                            rendererLeft = str_L;
                            break;
                        }
                        case 4: {
                            sar_L.setSeriesPaint(i - r - corr, (Paint)prop.getSeriesPaint());
                            sar_L.setSeriesStroke(i - r - corr, prop.getSeriesStroke());
                            sar_L.setSeriesShape(i - r - corr, prop.getSeriesShape());
                            sar_L.setSeriesOutlineStroke(i - r - corr, prop.getSeriesOutlineStroke());
                            sar_L.setSeriesOutlinePaint(i - r - corr, (Paint)prop.getSeriesOutlinePaint());
                            sar_L.setOutline(prop.getOutlineVisible());
                            rendererLeft = sar_L;
                            break;
                        }
                        case 5: {
                            dfr_L.setSeriesPaint(i - r - corr, (Paint)prop.getSeriesPaint());
                            dfr_L.setSeriesStroke(i - r - corr, prop.getSeriesStroke());
                            dfr_L.setSeriesShape(i - r - corr, prop.getSeriesShape());
                            dfr_L.setSeriesOutlineStroke(i - r - corr, prop.getSeriesOutlineStroke());
                            dfr_L.setSeriesOutlinePaint(i - r - corr, (Paint)prop.getSeriesOutlinePaint());
                            dfr_L.setShapesVisible(prop.getShapesVisible());
                            rendererLeft = dfr_L;
                            break;
                        }
                        default: {
                            lsr_L.setSeriesPaint(i - r - corr, (Paint)prop.getSeriesPaint());
                            lsr_L.setSeriesStroke(i - r - corr, prop.getSeriesStroke());
                            lsr_L.setSeriesShape(i - r - corr, prop.getSeriesShape());
                            lsr_L.setSeriesShapesVisible(i - r - corr, prop.getShapesVisible());
                            lsr_L.setSeriesLinesVisible(i - r - corr, prop.getLinesVisible());
                            lsr_L.setSeriesOutlineStroke(i - r - corr, prop.getSeriesOutlineStroke());
                            lsr_L.setSeriesOutlinePaint(i - r - corr, (Paint)prop.getSeriesOutlinePaint());
                            rendererLeft = lsr_L;
                            break;
                        }
                    }
                } else {
                    ++corr;
                }
            }
            if (prop.getPosChoice().getSelectedItem() != "right") continue;
            if (!this.propVector.get(i).isXSeries()) {
                ++r;
            }
            switch (rRight) {
                case 0: {
                    lsr_R.setSeriesPaint(i - l - corr, (Paint)prop.getSeriesPaint());
                    lsr_R.setSeriesStroke(i - l - corr, prop.getSeriesStroke());
                    lsr_R.setSeriesShape(i - l - corr, prop.getSeriesShape());
                    lsr_R.setSeriesShapesVisible(i - l - corr, prop.getShapesVisible());
                    lsr_R.setSeriesLinesVisible(i - l - corr, prop.getLinesVisible());
                    lsr_R.setUseOutlinePaint(true);
                    lsr_R.setSeriesFillPaint(i - r - corr, (Paint)prop.getSeriesFillPaint());
                    lsr_R.setUseFillPaint(true);
                    lsr_R.setSeriesOutlineStroke(i - l - corr, prop.getSeriesOutlineStroke());
                    lsr_R.setSeriesOutlinePaint(i - l - corr, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = lsr_R;
                    continue block16;
                }
                case 1: {
                    brr_R.setSeriesPaint(i - l - corr, (Paint)prop.getSeriesPaint());
                    brr_R.setSeriesStroke(i - l - corr, prop.getSeriesStroke());
                    brr_R.setSeriesOutlineStroke(i - l - corr, prop.getSeriesOutlineStroke());
                    brr_R.setSeriesOutlinePaint(i - l - corr, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = brr_R;
                    continue block16;
                }
                case 2: {
                    ar_R.setSeriesPaint(i - l - corr, (Paint)prop.getSeriesPaint());
                    ar_R.setSeriesStroke(i - l - corr, prop.getSeriesStroke());
                    ar_R.setSeriesShape(i - l - corr, prop.getSeriesShape());
                    ar_R.setSeriesOutlineStroke(i - l - corr, prop.getSeriesOutlineStroke());
                    ar_R.setSeriesOutlinePaint(i - l - corr, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = ar_R;
                    continue block16;
                }
                case 3: {
                    str_R.setSeriesPaint(i - l - corr, (Paint)prop.getSeriesPaint());
                    str_R.setSeriesStroke(i - l - corr, prop.getSeriesStroke());
                    str_R.setSeriesShape(i - l - corr, prop.getSeriesShape());
                    str_R.setSeriesOutlineStroke(i - l - corr, prop.getSeriesOutlineStroke());
                    str_R.setSeriesOutlinePaint(i - l - corr, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = str_R;
                    continue block16;
                }
                case 4: {
                    sar_R.setSeriesPaint(i - l - corr, (Paint)prop.getSeriesPaint());
                    sar_R.setSeriesStroke(i - l - corr, prop.getSeriesStroke());
                    sar_R.setSeriesShape(i - l - corr, prop.getSeriesShape());
                    sar_R.setSeriesOutlineStroke(i - l - corr, prop.getSeriesOutlineStroke());
                    sar_R.setSeriesOutlinePaint(i - l - corr, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = sar_R;
                    continue block16;
                }
                case 5: {
                    dfr_R.setSeriesPaint(i - l - corr, (Paint)prop.getSeriesPaint());
                    dfr_R.setSeriesStroke(i - l - corr, prop.getSeriesStroke());
                    dfr_R.setSeriesShape(i - l - corr, prop.getSeriesShape());
                    dfr_R.setSeriesOutlineStroke(i - l - corr, prop.getSeriesOutlineStroke());
                    dfr_R.setSeriesOutlinePaint(i - l - corr, (Paint)prop.getSeriesOutlinePaint());
                    dfr_R.setShapesVisible(prop.getShapesVisible());
                    rendererRight = dfr_R;
                    continue block16;
                }
                default: {
                    lsr_R.setSeriesPaint(i - l - corr, (Paint)prop.getSeriesPaint());
                    lsr_R.setSeriesStroke(i - l - corr, prop.getSeriesStroke());
                    lsr_R.setSeriesShape(i - l - corr, prop.getSeriesShape());
                    lsr_R.setSeriesShapesVisible(i - l - corr, prop.getShapesVisible());
                    lsr_R.setSeriesLinesVisible(i - l - corr, prop.getLinesVisible());
                    lsr_R.setSeriesOutlineStroke(i - l - corr, prop.getSeriesOutlineStroke());
                    lsr_R.setSeriesOutlinePaint(i - l - corr, (Paint)prop.getSeriesOutlinePaint());
                    rendererRight = lsr_R;
                }
            }
        }
        if (l > 0) {
            this.jxys.plotLeft((XYItemRenderer)rendererLeft, this.edLeftField.getText(), this.edXAxisField.getText(), this.invLeftBox.isSelected());
        }
        if (r > 0) {
            this.jxys.plotRight((XYItemRenderer)rendererRight, this.edRightField.getText(), this.edXAxisField.getText(), this.invRightBox.isSelected());
        }
        if (r == 0 && l == 0) {
            this.jxys.plotEmpty();
        }
        this.jxys.setTitle(this.edTitleField.getText());
    }

    public void handleRenderer() {
        int r = 0;
        int l = 0;
        int c = 0;
        for (int i = 0; i < this.propVector.size(); ++i) {
            if (this.propVector.get(i).getPosChoice().getSelectedItem() == "left") {
                if (!this.propVector.get(i).isXSeries()) {
                    ++l;
                } else {
                    ++c;
                }
            }
            if (this.propVector.get(i).getPosChoice().getSelectedItem() != "right") continue;
            if (!this.propVector.get(i).isXSeries()) {
                ++r;
                continue;
            }
            ++c;
        }
        if ((l < 2 || l > 2) && this.rLeftBox.getItemCount() == 6) {
            this.rLeftBox.removeItemAt(5);
        }
        if ((r < 2 || r > 2) && this.rRightBox.getItemCount() == 6) {
            this.rRightBox.removeItemAt(5);
        }
        if (l == 2 && this.rLeftBox.getItemCount() == 5) {
            this.rLeftBox.addItem("Difference");
        }
        if (r == 2 && this.rRightBox.getItemCount() == 5) {
            this.rRightBox.addItem("Difference");
        }
    }

    private void createOptionPanel() {
        GroupLayout optLayout = new GroupLayout(this.optionpanel);
        this.optionpanel.setLayout(optLayout);
        optLayout.setAutoCreateGaps(true);
        optLayout.setAutoCreateContainerGaps(true);
        this.addButton.addActionListener(this.addbuttonclick);
        GroupLayout.SequentialGroup optHGroup = optLayout.createSequentialGroup();
        GroupLayout.SequentialGroup optVGroup = optLayout.createSequentialGroup();
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edTitleField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edLeft).addComponent(this.edLeftField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edRight).addComponent(this.edRightField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edXAxis).addComponent(this.edXAxisField));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rLeftLabel).addComponent(this.rLeftBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.rRightLabel).addComponent(this.rRightBox));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invLeftBox).addComponent(this.addButton));
        optVGroup.addGroup(optLayout.createParallelGroup().addComponent(this.invRightBox).addComponent(this.applyButton));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitle).addComponent(this.edLeft).addComponent(this.edRight).addComponent(this.edXAxis).addComponent(this.rLeftLabel).addComponent(this.rRightLabel).addComponent(this.invLeftBox).addComponent(this.invRightBox));
        optHGroup.addGroup(optLayout.createParallelGroup().addComponent(this.edTitleField).addComponent(this.edLeftField).addComponent(this.edRightField).addComponent(this.edXAxisField).addComponent(this.rLeftBox).addComponent(this.rRightBox).addComponent(this.addButton).addGap(1, 1, 1).addComponent(this.applyButton));
        optLayout.setHorizontalGroup(optHGroup);
        optLayout.setVerticalGroup(optVGroup);
    }

    private void initGroupUI() {
        this.graphpanel.removeAll();
        JLabel nameLabel = new JLabel("Name");
        JLabel posLabel = new JLabel("Position");
        JLabel typeLabel = new JLabel("Colour / Position");
        JLabel colorLabel = new JLabel("Type/Colour");
        JLabel dataLabel = new JLabel("Data / Legend Entry");
        JLabel timeLabel = new JLabel("Data Range");
        JLabel emptyTimeLabel = new JLabel("    ");
        JLabel legendLabel = new JLabel("Legend Entry: ");
        this.gLayout = new GroupLayout(this.graphpanel);
        this.graphpanel.setLayout(this.gLayout);
        this.gLayout.setAutoCreateGaps(true);
        this.gLayout.setAutoCreateContainerGaps(true);
        this.hGroup = this.gLayout.createSequentialGroup();
        this.vGroup = this.gLayout.createSequentialGroup();
        this.group1 = this.gLayout.createParallelGroup();
        this.group2 = this.gLayout.createParallelGroup();
        this.group3 = this.gLayout.createParallelGroup();
        this.group4 = this.gLayout.createParallelGroup();
        this.group5 = this.gLayout.createParallelGroup();
        this.group6 = this.gLayout.createParallelGroup();
        this.group7 = this.gLayout.createParallelGroup();
        this.group8 = this.gLayout.createParallelGroup();
        this.group9 = this.gLayout.createParallelGroup();
        this.group10 = this.gLayout.createParallelGroup();
        this.group11 = this.gLayout.createParallelGroup();
        this.group12 = this.gLayout.createParallelGroup();
        this.group13 = this.gLayout.createParallelGroup();
        this.group14 = this.gLayout.createParallelGroup();
        this.group15 = this.gLayout.createParallelGroup();
        this.group1.addComponent(dataLabel);
        this.group2.addComponent(timeLabel);
        this.group3.addComponent(typeLabel);
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(dataLabel).addComponent(timeLabel).addComponent(typeLabel));
    }

    private void addPropGroup(GraphProperties prop) {
        this.isXAxisGroup.add(prop.getIsXAxisButton());
        JLabel space1 = new JLabel(" ");
        JLabel space2 = new JLabel(" ");
        JLabel space3 = new JLabel(" ");
        JLabel space4 = new JLabel(" ");
        JLabel space5 = new JLabel("   ");
        JLabel space6 = new JLabel("   ");
        JTextField lf = prop.getLegendField();
        this.group6.addComponent(space5);
        this.group1.addComponent(prop.getDataChoice()).addComponent(lf).addGap(20);
        this.group2.addComponent(prop.getDataChoiceSTART()).addComponent(prop.getDataChoiceEND());
        this.group3.addComponent(prop.getColorChoice()).addComponent(prop.getPosChoice());
        this.group4.addComponent(prop.getCustomizeButton()).addComponent(prop.getMaxButton());
        this.group9.addComponent(space3);
        this.group10.addComponent(prop.getIsXAxisButton());
        this.group11.addComponent(space4);
        this.group13.addComponent(prop.getRemButton());
        this.group14.addComponent(prop.getUpButton());
        this.group15.addComponent(prop.getDownButton());
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(prop.getDataChoice()).addComponent(prop.getDataChoiceSTART()).addComponent(space5).addComponent(prop.getColorChoice()).addComponent(space5).addComponent(prop.getCustomizeButton()).addComponent(prop.getIsXAxisButton()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(lf).addComponent(prop.getDataChoiceEND()).addComponent(prop.getMaxButton()).addComponent(prop.getPosChoice()).addComponent(space3).addComponent(space4).addComponent(prop.getRemButton()).addComponent(prop.getUpButton()).addComponent(prop.getDownButton()));
        this.vGroup.addGroup(this.gLayout.createParallelGroup().addGap(20));
    }

    private void finishGroupUI() {
        this.hGroup.addGroup(this.group1);
        this.hGroup.addGroup(this.group2);
        this.hGroup.addGroup(this.group6);
        this.hGroup.addGroup(this.group3);
        this.hGroup.addGroup(this.group4);
        this.hGroup.addGroup(this.group9);
        this.hGroup.addGroup(this.group10);
        this.hGroup.addGroup(this.group11);
        this.hGroup.addGroup(this.group12);
        this.hGroup.addGroup(this.group13);
        this.hGroup.addGroup(this.group14);
        this.hGroup.addGroup(this.group15);
        this.gLayout.setHorizontalGroup(this.hGroup);
        this.gLayout.setVerticalGroup(this.vGroup);
    }

    public JPanel getPanel() {
        return this.mainpanel;
    }

    public JPanel getCTSPlot() {
        return this.ctsplot.getPanel();
    }

    public void setParent(JFrame parent) {
        this.parent = parent;
    }

    private void editProperties() {
        JDialog propDlg = new JDialog((Frame)this.parent, "Properties");
        int ct = this.headers.length;
        JLabel[] labels = new JLabel[ct];
        JTextField[] textFields = new JTextField[ct];
        JPanel[] inputpanels = new JPanel[ct];
        JPanel proppanel = new JPanel();
        proppanel.setLayout(new GridLayout(ct, 1));
        for (int i = 0; i < ct; ++i) {
            labels[i] = new JLabel(this.headers[i]);
            textFields[i] = new JTextField(this.headers[i]);
            inputpanels[i] = new JPanel();
            inputpanels[i].setLayout(new FlowLayout());
            inputpanels[i].add(labels[i]);
            inputpanels[i].add(textFields[i]);
        }
        JScrollPane propPane = new JScrollPane(proppanel);
    }

    public void createActionListener() {
        Vector addAction = new Vector();
        for (int k = 0; k < this.graphCount; ++k) {
            this.activationChange[k] = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                }
            };
        }
    }

    private class AddGraphDlg
    extends JDialog {
        boolean result;
        int max;
        String side;
        int side_index;
        int position;
        JSpinner posSpinner;
        JComboBox sideChoice;
        JButton okButton;
        JLabel pos_label;
        JLabel side_label;
        ActionListener ok;

        public AddGraphDlg() {
            super(JXYConfigurator.this.thisDlg, "Add Graph", true);
            this.result = false;
            this.ok = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    AddGraphDlg.this.side_index = AddGraphDlg.this.sideChoice.getSelectedIndex();
                    AddGraphDlg.this.position = (Integer)AddGraphDlg.this.posSpinner.getValue();
                    AddGraphDlg.this.result = true;
                    AddGraphDlg.this.setVisible(false);
                }
            };
            this.setIconImages(JAMSTools.getJAMSIcons());
            Point parentloc = JXYConfigurator.this.thisDlg.getLocation();
            this.setLocation(parentloc.x + 50, parentloc.y + 50);
            this.createPanel();
        }

        void createPanel() {
            this.setLayout(new FlowLayout());
            this.max = JXYConfigurator.this.propVector.size();
            String[] posArray = new String[]{"left", "right"};
            this.posSpinner = new JSpinner(new SpinnerNumberModel(this.max, 0, this.max, 1));
            this.sideChoice = new JComboBox<String>(posArray);
            this.sideChoice.setSelectedIndex(0);
            this.okButton = new JButton("OK");
            this.pos_label = new JLabel("position after: ");
            this.side_label = new JLabel("side: ");
            this.add(this.side_label);
            this.add(this.sideChoice);
            this.add(this.pos_label);
            this.add(this.posSpinner);
            this.add(this.okButton);
            this.okButton.addActionListener(this.ok);
            this.pack();
        }

        String getSide() {
            this.side = this.side_index == 0 ? "left" : "right";
            return this.side;
        }

        int getPosition() {
            return this.position;
        }

        boolean getResult() {
            return this.result;
        }
    }

    private class HiResPanel
    extends JPanel {
        BufferedImage bi;

        public HiResPanel(BufferedImage bi) {
            this.bi = bi;
        }

        @Override
        public void paint(Graphics g) {
            g.drawImage(this.bi, 0, 0, this);
        }
    }
}

