/*
 * Decompiled with CFR 0.152.
 */
package jams.components.gui.spreadsheet;

import jams.components.gui.spreadsheet.JAMSTableModel;
import jams.components.gui.spreadsheet.JTSConfigurator;
import jams.components.gui.spreadsheet.JXYConfigurator;
import jams.data.Attribute;
import jams.gui.tools.GUIHelper;
import jams.io.JAMSTableDataArray;
import jams.model.JAMSGUIComponent;
import jams.model.JAMSVarDescription;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class JAMSSpreadSheet
extends JAMSGUIComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Column Name Array")
    public Attribute.StringArray headers;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Current time")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Array with data of one row")
    public Attribute.Double[] rowarray;
    private final String title = "JAMSSpreadSheet v0.94";
    private final int COLWIDTH = 8;
    private JPanel panel = new JPanel();
    private String panelname = "spreadsheet";
    private int numberOfColumns = 0;
    private JFrame parent_frame;
    private boolean timeRuns = false;
    private boolean ctsIsOpen = false;
    private Vector<Vector> data = new Vector();
    private Vector<String> colnames = new Vector();
    private double[] rowdata;
    GridBagLayout panellayout = new GridBagLayout();
    GridBagConstraints grid = new GridBagConstraints();
    private JScrollPane scrollpane = new JScrollPane();
    private JScrollPane scrollpane2;
    private JButton calcbutton = new JButton("Calculate");
    private JButton importbutton = new JButton("Import");
    private JButton openbutton = new JButton("Open");
    private JButton savebutton = new JButton("Save");
    private JButton plotButton = new JButton("Time Plot");
    private JButton dataplotButton = new JButton("Data Plot");
    private JLabel headerlabel = new JLabel();
    private JLabel titleLabel = new JLabel("JAMSSpreadSheet v0.94");
    private JLabel calclabel = new JLabel("calclabel");
    private JLabel label2 = new JLabel();
    private JLabel opensavealert = new JLabel("");
    private JLabel plotalert = new JLabel();
    private JCheckBox onthefly = new JCheckBox("On the fly", false);
    private JTextField editField = new JTextField();
    private JAMSTableModel tmodel;
    private JTableHeader tableHeader;
    JTable table;
    private String[] calclist = new String[]{"Sum    ", "Mean   "};
    JComboBox calculations = new JComboBox<String>(this.calclist);
    private int kindofcalc = 0;
    ActionListener calcbuttonclick = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSSpreadSheet.this.kindofcalc = JAMSSpreadSheet.this.calculations.getSelectedIndex();
            if (JAMSSpreadSheet.this.kindofcalc == 0) {
                JAMSSpreadSheet.this.calclabel.setText("Sum: " + JAMSSpreadSheet.this.calcsum());
            }
            if (JAMSSpreadSheet.this.kindofcalc == 1) {
                JAMSSpreadSheet.this.calclabel.setText("Mean: " + JAMSSpreadSheet.this.calcmean());
            }
        }
    };
    ActionListener saveAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            JAMSSpreadSheet.this.save();
        }
    };
    ActionListener openAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int result;
            try {
                result = GUIHelper.showYesNoCancelDlg((Component)JAMSSpreadSheet.this.getModel().getRuntime().getFrame(), (String)"Do you want to save this sheet before?", (String)"Attention");
            }
            catch (NullPointerException npe) {
                result = GUIHelper.showYesNoCancelDlg((Component)JAMSSpreadSheet.this.parent_frame, (String)"Do you want to save this sheet before?", (String)"Attention");
            }
            if (result == 0) {
                JAMSSpreadSheet.this.save();
                JAMSSpreadSheet.this.open();
            }
            if (result == 1) {
                JAMSSpreadSheet.this.open();
            }
        }
    };
    ActionListener importAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            int result;
            try {
                result = GUIHelper.showYesNoCancelDlg((Component)JAMSSpreadSheet.this.getModel().getRuntime().getFrame(), (String)"Do you want to save this sheet before?", (String)"Attention");
            }
            catch (NullPointerException npe) {
                result = GUIHelper.showYesNoCancelDlg((Component)JAMSSpreadSheet.this.parent_frame, (String)"Do you want to save this sheet before?", (String)"Attention");
            }
            if (result == 0) {
                JAMSSpreadSheet.this.save();
                JAMSSpreadSheet.this.importWSFile();
            }
            if (result == 1) {
                JAMSSpreadSheet.this.importWSFile();
            }
        }
    };
    ActionListener plotAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            block2: {
                try {
                    JAMSSpreadSheet.this.openCTS();
                }
                catch (ClassCastException cce) {
                    if (!JAMSSpreadSheet.this.timeRuns) break block2;
                    JAMSSpreadSheet.this.table.setColumnSelectionInterval(1, JAMSSpreadSheet.this.table.getColumnCount() - 1);
                    JAMSSpreadSheet.this.openCTS();
                }
            }
        }
    };
    ActionListener dataplotAction = new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            block3: {
                try {
                    Class<?> test = JAMSSpreadSheet.this.table.getValueAt(0, JAMSSpreadSheet.this.table.getSelectedColumns()[0]).getClass();
                    if (test == Attribute.Calendar.class) {
                        JAMSSpreadSheet.this.table.setColumnSelectionInterval(1, JAMSSpreadSheet.this.table.getColumnCount() - 1);
                    }
                    JAMSSpreadSheet.this.openCXYS();
                }
                catch (ClassCastException cce) {
                    if (!JAMSSpreadSheet.this.timeRuns) break block3;
                    JAMSSpreadSheet.this.table.setColumnSelectionInterval(1, JAMSSpreadSheet.this.table.getColumnCount() - 1);
                    JAMSSpreadSheet.this.openCXYS();
                }
            }
        }
    };

    public JAMSSpreadSheet() {
    }

    public JAMSSpreadSheet(JFrame parent, String[] headers) {
        this.parent_frame = parent;
        this.headers = this.getModel().getRuntime().getDataFactory().createStringArray();
        this.headers.setValue(headers);
    }

    public JPanel getPanel() {
        return this.panel;
    }

    public void init() {
        this.tmodel = new JAMSTableModel();
        this.createPanel();
        this.updateGUI();
    }

    public void save() {
        int colcount = this.tmodel.getColumnCount();
        int rowcount = this.tmodel.getRowCount();
        String[] columnNames = this.tmodel.getCoulumnNameArray();
        try {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showSaveDialog(this.panel);
            File file = chooser.getSelectedFile();
            FileWriter filewriter = new FileWriter(file);
            for (int j = 0; j < colcount; ++j) {
                filewriter.write(columnNames[j], 0, columnNames[j].length());
                filewriter.write("\t");
            }
            filewriter.write("\r\n#");
            filewriter.write("\r\n");
            for (int k = 0; k < rowcount; ++k) {
                for (int i = 0; i < colcount; ++i) {
                    String value = this.table.getValueAt(k, i).toString();
                    filewriter.write(value, 0, value.length());
                    filewriter.write("\t");
                }
                filewriter.write("\r\n");
            }
            filewriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void importWSFile() {
        String CONTEXT = "@context";
        String JAMSDATADUMP = "#JAMSdatadump";
        String ATTRIBUTES = "@attributes";
        String TYPES = "@types";
        String DATA = "@data";
        String START = "@start";
        String END = "@end";
        String ID = "ID";
        String TIME = "Attribute.Calendar";
        String METADATA = "@metadata";
        String TYPE_ = "#TYPE_";
        String text = "";
        String rowtext = "";
        String itemtext = "";
        String[] headerBuff = new String[256];
        int colNumber = 0;
        double[] rowBuffer = null;
        ArrayList<String> header_list = new ArrayList<String>();
        String[] headers = new String[]{""};
        Vector<double[]> arrayVector = new Vector<double[]>();
        Vector<Attribute.Calendar> timeVector = new Vector<Attribute.Calendar>();
        boolean headerSet = false;
        boolean line = false;
        boolean k = false;
        this.tmodel = new JAMSTableModel();
        this.tmodel.setTimeRuns(false);
        this.timeRuns = false;
        int timeIndex = -1;
        try {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(this.panel);
            if (returnVal != 0) {
                throw new FileNotFoundException();
            }
            File file = chooser.getSelectedFile();
            FileReader fReader = new FileReader(file);
            BufferedReader bReader = new BufferedReader(fReader);
            StringBuffer stBuff = new StringBuffer();
            char[] c = new char[100];
            if (bReader.ready()) {
                String att_name;
                StringTokenizer attributes;
                rowtext = bReader.readLine();
                if (rowtext.compareTo("@context") == 0) {
                    while (bReader.ready()) {
                        rowtext = bReader.readLine();
                        if (rowtext.compareTo("@attributes") == 0) {
                            rowtext = bReader.readLine();
                            attributes = new StringTokenizer(rowtext, "\t");
                            att_name = "";
                            while (attributes.hasMoreTokens()) {
                                try {
                                    att_name = attributes.nextToken();
                                    header_list.add(att_name);
                                    if (att_name.compareTo("ID") == 0) {
                                        int n = colNumber;
                                    }
                                    ++colNumber;
                                }
                                catch (NullPointerException nullPointerException) {}
                            }
                            colNumber = header_list.size();
                            headers = new String[colNumber];
                            header_list.toArray(headers);
                        }
                        if (rowtext.compareTo("@types") == 0) {
                            String[] types = new String[colNumber];
                            rowtext = bReader.readLine();
                            StringTokenizer typerow = new StringTokenizer(rowtext, "\t");
                            int c_types = 0;
                            String type_name = "";
                            while (typerow.hasMoreTokens()) {
                                try {
                                    types[c_types] = type_name = typerow.nextToken();
                                    if (type_name.compareTo("Attribute.Calendar") == 0) {
                                        timeIndex = c_types;
                                        this.tmodel.setTimeRuns(true);
                                        this.timeRuns = true;
                                    }
                                    ++c_types;
                                }
                                catch (NullPointerException nullPointerException) {}
                            }
                        }
                        if (rowtext.compareTo("@data") != 0 || (rowtext = bReader.readLine()).compareTo("@start") != 0) continue;
                        rowtext = bReader.readLine();
                        while (rowtext.compareTo("@end") != 0) {
                            StringTokenizer datarow = new StringTokenizer(rowtext, "\t");
                            rowBuffer = new double[colNumber - 1];
                            for (int col = 0; col < colNumber; ++col) {
                                if (col == timeIndex && this.timeRuns) {
                                    Attribute.Calendar timeval = this.getModel().getRuntime().getDataFactory().createCalendar();
                                    timeval.setValue(datarow.nextToken());
                                    timeVector.add(timeval);
                                    continue;
                                }
                                if (col > timeIndex) {
                                    rowBuffer[col - 1] = new Double(datarow.nextToken());
                                    continue;
                                }
                                rowBuffer[col] = new Double(datarow.nextToken());
                            }
                            arrayVector.add(rowBuffer);
                            rowtext = bReader.readLine();
                        }
                    }
                }
                if (rowtext.compareTo("#JAMSdatadump") == 0) {
                    System.out.println("JAMSdatadump");
                    while (bReader.ready()) {
                        rowtext = bReader.readLine();
                        if (rowtext.compareTo("@metadata") == 0) {
                            rowtext = bReader.readLine();
                            attributes = new StringTokenizer(rowtext, "\t");
                            att_name = "";
                            while (attributes.hasMoreTokens()) {
                                try {
                                    att_name = attributes.nextToken();
                                    header_list.add(att_name);
                                    System.out.println("attribute name: " + att_name);
                                }
                                catch (NullPointerException timeval) {}
                            }
                            colNumber = header_list.size();
                            headers = new String[colNumber];
                            header_list.toArray(headers);
                            headerSet = true;
                            System.out.println("col_number: " + colNumber);
                        }
                        if (rowtext.compareTo("@data") != 0) continue;
                        rowtext = bReader.readLine();
                        while (rowtext.compareTo("@end") != 0) {
                            JAMSTableDataArray jamstda = new JAMSTableDataArray(rowtext);
                            timeVector.add(jamstda.getTime());
                            String[] theValues = jamstda.getValues();
                            if (theValues != null) {
                                rowBuffer = new double[theValues.length];
                                for (int j = 0; j < theValues.length; ++j) {
                                    rowBuffer[j] = new Double(theValues[j]);
                                }
                            }
                            arrayVector.add(rowBuffer);
                            rowtext = bReader.readLine();
                        }
                    }
                }
            }
            this.tmodel = new JAMSTableModel();
            this.tmodel.setTimeRuns(true);
            this.timeRuns = true;
            if (this.timeRuns) {
                this.tmodel.setTimeVector(timeVector);
            }
            this.tmodel.setNewDataVector(arrayVector);
            this.tmodel.setColumnNames(headers);
        }
        catch (Exception ex) {
            System.out.println("Exception:" + ex.getMessage());
            ex.printStackTrace();
            try {
                GUIHelper.showErrorDlg((Component)this.getModel().getRuntime().getFrame(), (String)"File reading failed", (String)"Error");
            }
            catch (NullPointerException npe) {
                GUIHelper.showErrorDlg((Component)this.parent_frame, (String)"File reading failed", (String)"Error");
            }
            System.out.println("Lesen fehlgeschlagen!");
        }
        this.updateGUI();
    }

    public void open() {
        String text = "";
        String rowtext = "";
        String itemtext = "";
        String[] headerBuff = new String[256];
        int colNumber = 0;
        double[] rowBuffer = null;
        String[] headers = null;
        Vector<double[]> arrayVector = new Vector<double[]>();
        Vector<Attribute.Calendar> timeVector = new Vector<Attribute.Calendar>();
        boolean headerSet = false;
        int line = 0;
        int k = 0;
        this.tmodel = new JAMSTableModel();
        this.tmodel.setTimeRuns(true);
        this.timeRuns = true;
        try {
            JFileChooser chooser = new JFileChooser();
            int returnVal = chooser.showOpenDialog(this.panel);
            File file = chooser.getSelectedFile();
            FileReader fReader = new FileReader(file);
            StringBuffer stBuff = new StringBuffer();
            char[] c = new char[100];
            while (fReader.ready()) {
                int i = fReader.read(c, 0, c.length);
                stBuff.append(c, 0, i);
            }
            fReader.close();
            text = stBuff.toString();
        }
        catch (IOException ex) {
            System.out.println("Lesen fehlgeschlagen!");
        }
        StringTokenizer row = new StringTokenizer(text, "\r\n");
        while (row.hasMoreTokens()) {
            rowtext = row.nextToken();
            StringTokenizer item = new StringTokenizer(rowtext, "\t");
            while (item.hasMoreTokens()) {
                itemtext = item.nextToken();
                try {
                    if (line == 0) {
                        headerBuff[k] = itemtext;
                        ++colNumber;
                    } else if (line == 1) {
                        headers = new String[colNumber];
                        for (int l = 0; l < colNumber; ++l) {
                            headers[l] = headerBuff[l];
                        }
                        rowBuffer = null;
                    } else if (k == 0) {
                        Attribute.Calendar timeval = this.getModel().getRuntime().getDataFactory().createCalendar();
                        timeval.setValue(itemtext);
                        timeVector.add(timeval);
                    } else {
                        rowBuffer[k - 1] = new Double(itemtext);
                    }
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                ++k;
            }
            if (rowBuffer != null) {
                arrayVector.add(rowBuffer);
            }
            rowBuffer = new double[colNumber - 1];
            k = 0;
            ++line;
        }
        this.tmodel = new JAMSTableModel();
        this.tmodel.setTimeRuns(true);
        this.timeRuns = true;
        this.tmodel.setTimeVector(timeVector);
        this.tmodel.setNewDataVector(arrayVector);
        String headertest = "";
        this.tmodel.setColumnNames(headers);
        this.updateGUI();
    }

    private void openCTS() {
        try {
            JTSConfigurator jts = new JTSConfigurator(this.getModel().getRuntime().getFrame(), this.table);
        }
        catch (NullPointerException npe) {
            JTSConfigurator jts = new JTSConfigurator(this.parent_frame, this.table);
        }
    }

    private void openCXYS() {
        try {
            JXYConfigurator jxys = new JXYConfigurator(this.getModel().getRuntime().getFrame(), this.table);
        }
        catch (NullPointerException npe) {
            JXYConfigurator jxys = new JXYConfigurator(this.parent_frame, this.table);
        }
    }

    private double calcsum() {
        double sum = 0.0;
        int[] rows = this.table.getSelectedRows();
        int ix = rows.length;
        int[] columns = this.table.getSelectedColumns();
        int kx = columns.length;
        for (int k = 0; k < kx; ++k) {
            for (int i = 0; i < ix; ++i) {
                if (this.table.getValueAt(rows[i], columns[k]).getClass() != String.class) {
                    sum += ((Double)this.table.getValueAt(rows[i], columns[k])).doubleValue();
                    continue;
                }
                sum += 0.0;
            }
        }
        return sum;
    }

    private double calcmean() {
        double sum = 0.0;
        int[] rows = this.table.getSelectedRows();
        int ix = rows.length;
        int[] columns = this.table.getSelectedColumns();
        int kx = columns.length;
        for (int k = 0; k < kx; ++k) {
            for (int i = 0; i < ix; ++i) {
                if (this.table.getValueAt(rows[i], columns[k]).getClass() != String.class) {
                    sum += ((Double)this.table.getValueAt(rows[i], columns[k])).doubleValue();
                    continue;
                }
                sum += 0.0;
            }
        }
        double mean = 0.0;
        if (ix == 1) {
            mean = sum / (double)kx;
        }
        if (kx == 1) {
            mean = sum / (double)ix;
        }
        if (kx != 1 && ix != 1) {
            mean = sum / (double)(kx * ix);
        }
        return sum;
    }

    public String getPanelName() {
        String name = this.panelname;
        return name;
    }

    public void setNumberOfColumns(int numberOfColumns) {
        this.numberOfColumns = numberOfColumns;
    }

    public void setColumnNameArray(String[] names) {
        this.tmodel.setColumnNames(names);
    }

    public void addRowArray(double[] data) {
    }

    public void updateValue(double value, int rowIndex, int columnIndex) {
    }

    public void updateGUI() {
        this.table.setModel(this.tmodel);
        this.scrollpane.setViewportView(this.table);
        this.panel.repaint();
    }

    public void makeTable() {
        this.table = new JTable(this.tmodel);
        this.tableHeader = this.table.getTableHeader();
        this.table.getTableHeader().setReorderingAllowed(false);
        HeaderHandler mouseListener = new HeaderHandler();
        this.tableHeader.addMouseListener(mouseListener);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(true);
        this.table.setDragEnabled(false);
        this.table.setCellSelectionEnabled(true);
        this.table.setAutoResizeMode(0);
    }

    public void createPanel() {
        this.panel.setLayout(new BorderLayout(10, 10));
        JPanel controlpanel = new JPanel();
        JPanel helperpanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        controlpanel.setLayout(gbl);
        JPanel headerpanel = new JPanel();
        headerpanel.setLayout(new GridLayout(1, 2));
        this.scrollpane.setVerticalScrollBar(new JScrollBar(1));
        this.scrollpane.setVerticalScrollBarPolicy(22);
        this.scrollpane2 = new JScrollPane(this.scrollpane);
        if (this.time != null) {
            this.tmodel.setTimeRuns(true);
            String[] colheads = new String[this.headers.getValue().length + 1];
            colheads[0] = "Time [yyyy-mm-dd hh:ss]";
            for (int i = 1; i <= this.headers.getValue().length; ++i) {
                colheads[i] = this.headers.getValue()[i - 1];
            }
            this.setColumnNameArray(colheads);
        } else {
            this.setColumnNameArray(this.headers.getValue());
        }
        this.makeTable();
        GUIHelper.addGBComponent((Container)controlpanel, (GridBagLayout)gbl, (Component)this.importbutton, (int)0, (int)0, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)controlpanel, (GridBagLayout)gbl, (Component)this.openbutton, (int)0, (int)2, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)controlpanel, (GridBagLayout)gbl, (Component)this.savebutton, (int)0, (int)3, (int)1, (int)2, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)controlpanel, (GridBagLayout)gbl, (Component)this.plotButton, (int)0, (int)5, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)controlpanel, (GridBagLayout)gbl, (Component)this.dataplotButton, (int)0, (int)6, (int)1, (int)1, (double)0.0, (double)0.0);
        GUIHelper.addGBComponent((Container)controlpanel, (GridBagLayout)gbl, (Component)this.onthefly, (int)0, (int)7, (int)1, (int)1, (double)0.0, (double)0.0);
        this.importbutton.addActionListener(this.importAction);
        this.openbutton.addActionListener(this.openAction);
        this.savebutton.addActionListener(this.saveAction);
        this.plotButton.addActionListener(this.plotAction);
        this.dataplotButton.addActionListener(this.dataplotAction);
        headerpanel.add(this.titleLabel);
        headerpanel.add(this.headerlabel);
        helperpanel.add(controlpanel);
        this.panel.add((Component)headerpanel, "North");
        this.panel.add((Component)this.scrollpane2, "Center");
        this.panel.add((Component)helperpanel, "East");
    }

    private GridBagConstraints makegrid(int xpos, int ypos, int width, int height) {
        GridBagConstraints grid = new GridBagConstraints();
        grid.gridx = xpos;
        grid.gridy = ypos;
        grid.gridwidth = width;
        grid.gridheight = height;
        grid.insets = new Insets(0, 0, 0, 0);
        return grid;
    }

    public void addCurrentTime() {
        this.tmodel.addTime(this.time);
    }

    public void addTime(Attribute.Calendar time) {
        this.tmodel.addTime(time);
    }

    public void run() {
        if (this.time == null) {
            this.rowdata = new double[this.rowarray.length];
            for (int i = 0; i < this.rowarray.length; ++i) {
                this.rowdata[i] = this.rowarray[i].getValue();
            }
            this.timeRuns = false;
        } else {
            this.timeRuns = true;
            this.addCurrentTime();
        }
        this.tmodel.addRowArray(this.rowarray);
        if (this.onthefly.isSelected()) {
            this.updateGUI();
        }
    }

    public void cleanup() {
        this.updateGUI();
    }

    private class HeaderHandler
    extends MouseAdapter {
        int button = -1;
        int[] selectedColumns;
        int col_START = 0;
        int col_END = 0;

        private HeaderHandler() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            TableColumnModel tcm = h.getColumnModel();
            int viewCol = tcm.getColumnIndexAtX(e.getX());
            this.button = e.isShiftDown() ? 1 : (e.isControlDown() ? 2 : -1);
            block0 : switch (this.button) {
                case 1: {
                    this.col_END = JAMSSpreadSheet.this.table.getColumnModel().getColumn(viewCol).getModelIndex();
                    JAMSSpreadSheet.this.table.addColumnSelectionInterval(this.col_START, this.col_END);
                    break;
                }
                case 2: {
                    this.selectedColumns = JAMSSpreadSheet.this.table.getSelectedColumns();
                    this.col_END = JAMSSpreadSheet.this.table.getColumnModel().getColumn(viewCol).getModelIndex();
                    JAMSSpreadSheet.this.table.addColumnSelectionInterval(this.col_END, this.col_END);
                    for (int k = 0; k < this.selectedColumns.length; ++k) {
                        if (this.col_END != this.selectedColumns[k]) continue;
                        JAMSSpreadSheet.this.table.removeColumnSelectionInterval(this.col_END, this.col_END);
                        break block0;
                    }
                    break;
                }
                default: {
                    this.col_START = JAMSSpreadSheet.this.table.getColumnModel().getColumn(viewCol).getModelIndex();
                    JAMSSpreadSheet.this.table.setColumnSelectionInterval(this.col_START, this.col_START);
                }
            }
            JAMSSpreadSheet.this.table.setRowSelectionInterval(0, JAMSSpreadSheet.this.table.getRowCount() - 1);
            this.button = -1;
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
            h.setCursor(new Cursor(12));
        }

        @Override
        public void mouseExited(MouseEvent e) {
            JTableHeader h = (JTableHeader)e.getSource();
        }
    }
}

