/*
 * Decompiled with CFR 0.152.
 */
package jams.components.demo.abc;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;

@JAMSComponentDescription(title="ABCModel precip reader", author="Sven Kralisch", description="ABC model climate data reader", date="17.11.2010", version="1.0.0")
public class ABCDataReader
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Input data file name")
    public Attribute.String fileName;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Precip value read from file")
    public Attribute.Double precip;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Runoff value read from file")
    public Attribute.Double runoff;
    ArrayList<double[]> data = new ArrayList();
    int counter = 0;

    public void init() {
        BufferedReader reader = null;
        try {
            String line;
            if (this.fileName == null) {
                this.getModel().getRuntime().sendHalt("You should specify a file for ABCDataReader");
                return;
            }
            File file = new File(this.getModel().getWorkspaceDirectory(), this.fileName.getValue());
            if (!file.isFile()) {
                this.getModel().getRuntime().sendHalt("The  file " + this.fileName.getValue() + " is not existing. Aborting.");
            }
            reader = new BufferedReader(new FileReader(file));
            while (!reader.readLine().startsWith("=")) {
            }
            while ((line = reader.readLine()) != null) {
                if (line == null) {
                    this.getModel().getRuntime().sendHalt("There is no more data in " + this.fileName + ". Check your data file or timeInterval");
                    return;
                }
                StringTokenizer st = new StringTokenizer(line);
                String token = st.nextToken();
                double[] dataset = new double[]{Double.parseDouble(st.nextToken()), Double.parseDouble(st.nextToken())};
                this.data.add(dataset);
            }
            reader.close();
        }
        catch (FileNotFoundException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.counter = 0;
    }

    public void run() {
        this.precip.setValue(this.data.get(this.counter)[0]);
        this.runoff.setValue(this.data.get(this.counter)[1]);
        ++this.counter;
    }

    public void cleanup() {
    }
}

