/*
 * Decompiled with CFR 0.152.
 */
package jams.components.conditional;

import jams.data.Attribute;
import jams.model.Component;
import jams.model.ComponentEnumerator;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSContext;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="DoubleConditionalContext", author="Sven Kralisch", date="9. April 2008", description="This component represents a JAMS context which can be used to conditionally execute components. This context must contain two components. If \"value1\" equals \"value2\", the first one will be executed, otherwise the second one.", version="1.0_1")
@VersionComments(entries={@VersionComments.Entry(version="1.0_1", date="2015-02-18", comment="Fixed minor issue with wrong counting of run() invocations")})
public class DoubleConditionalContext
extends JAMSContext {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Double attribute \"value1\"")
    public Attribute.Double value1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Double attribute \"value2\"")
    public Attribute.Double value2;

    public ComponentEnumerator getRunEnumerator() {
        return new RunEnumerator();
    }

    public long getNumberOfIterations() {
        return -1L;
    }

    public long getRunCount() {
        return -1L;
    }

    static /* synthetic */ Component[] access$000(DoubleConditionalContext x0) {
        return x0.getCompArray();
    }

    public class RunEnumerator
    implements ComponentEnumerator {
        final JAMSComponent dummy = new JAMSComponent(){

            public void run() {
            }
        };
        Component[] compArray = DoubleConditionalContext.access$000(DoubleConditionalContext.this);
        boolean next = true;

        public boolean hasNext() {
            if (this.next) {
                this.next = false;
                return true;
            }
            return false;
        }

        public boolean hasPrevious() {
            return !this.hasNext();
        }

        public Component next() {
            DoubleConditionalContext.this.runCount++;
            if (DoubleConditionalContext.this.value1.getValue() == DoubleConditionalContext.this.value2.getValue()) {
                return this.compArray[0];
            }
            if (this.compArray.length < 2 || this.compArray[1] == null) {
                return this.dummy;
            }
            return this.compArray[1];
        }

        public Component previous() {
            return this.next();
        }

        public void reset() {
            this.next = true;
        }
    }
}

