/*
 * Decompiled with CFR 0.152.
 */
package jams.components.calc;

import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="DoubleArrayMultiply", author="Sven Kralisch", description="Multiply double array with one or many double values and return the result", date="2020-01-14", version="1.0_0")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", comment="Initial version")})
public class DoubleArrayMultiply
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="First operand")
    public Attribute.DoubleArray da;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Second operand")
    public Attribute.Double[] d;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="Result of d1*d2 (element-wise)")
    public Attribute.DoubleArray result;
    transient Runnable job;

    public void run() {
        if (this.da.getValue().length == this.d.length) {
            double[] d1 = this.da.getValue();
            double[] r = new double[d1.length];
            for (int i = 0; i < d1.length; ++i) {
                r[i] = d1[i] * this.d[i].getValue();
            }
            this.result.setValue(r);
        } else if (this.d.length == 1) {
            double[] d1 = this.da.getValue();
            double[] r = new double[d1.length];
            for (int i = 0; i < d1.length; ++i) {
                r[i] = d1[i] * this.d[0].getValue();
            }
            this.result.setValue(r);
        } else {
            this.getModel().getRuntime().sendHalt("Attribute d2 has wrong length, should be 1 or length of d1");
        }
    }
}

