/*
 * Decompiled with CFR 0.152.
 */
package jams.components.calc;

import de.odysseus.el.ExpressionFactoryImpl;
import de.odysseus.el.util.SimpleContext;
import de.odysseus.el.util.SimpleResolver;
import jams.components.calc.DoubleArrayFunctions;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSVarDescription;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Properties;
import javax.el.ELContext;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.el.ValueExpression;

public class DoubleArrayCalculator
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="vector data1")
    public Attribute.DoubleArray X1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="vector data2")
    public Attribute.DoubleArray X2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="scalar data1")
    public Attribute.Double[] s1;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="scalar data2")
    public Attribute.Double[] s2;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="scalar weight")
    public Attribute.Double w;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READWRITE, description="scalar output")
    public Attribute.Double[] y;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time object")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="time period")
    public Attribute.TimeInterval I;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="expression")
    public Attribute.String expr;
    transient ExpressionFactory factory = null;
    transient SimpleContext context = new SimpleContext((ELResolver)new SimpleResolver());
    transient ValueExpression valueExpr = null;
    transient ValueExpression X1Expr = null;
    transient ValueExpression X2Expr = null;
    transient ValueExpression s1Expr = null;
    transient ValueExpression s2Expr = null;
    transient ValueExpression wExpr = null;
    transient ValueExpression timeExpr = null;
    transient ValueExpression intervalExpr = null;
    transient ValueExpression yExpr = null;

    public void init() {
        Properties properties = new Properties();
        properties.put("javax.el.cacheSize", "1000");
        properties.put("javax.el.methodInvocations", "false");
        properties.put("javax.el.nullProperties", "false");
        properties.put("javax.el.varArgs", "false");
        properties.put("javax.el.ignoreReturnType", "false");
        this.factory = new ExpressionFactoryImpl(properties);
        this.context = DoubleArrayFunctions.getContext();
        this.valueExpr = this.factory.createValueExpression((ELContext)this.context, "${" + this.expr.getValue() + "}", double[].class);
        this.wExpr = this.factory.createValueExpression((ELContext)this.context, "${w}", Double.TYPE);
        this.X1Expr = this.factory.createValueExpression((ELContext)this.context, "${X1}", double[].class);
        this.X2Expr = this.factory.createValueExpression((ELContext)this.context, "${X2}", double[].class);
        this.s1Expr = this.factory.createValueExpression((ELContext)this.context, "${s1}", double[].class);
        this.s2Expr = this.factory.createValueExpression((ELContext)this.context, "${s2}", double[].class);
        this.yExpr = this.factory.createValueExpression((ELContext)this.context, "${y}", double[].class);
        this.timeExpr = this.factory.createValueExpression((ELContext)this.context, "${time}", Attribute.Calendar.class);
        this.intervalExpr = this.factory.createValueExpression((ELContext)this.context, "${I}", Attribute.TimeInterval.class);
    }

    public void run() {
        double[] y;
        int i;
        int n = this.y.length;
        if (this.X1 != null) {
            this.X1Expr.setValue((ELContext)this.context, (Object)this.X1.getValue());
        }
        if (this.X2 != null) {
            this.X2Expr.setValue((ELContext)this.context, (Object)this.X2.getValue());
        }
        if (this.s1 != null) {
            double[] s1 = new double[n];
            for (i = 0; i < n; ++i) {
                s1[i] = this.s1[i].getValue();
            }
            this.s1Expr.setValue((ELContext)this.context, (Object)s1);
        }
        if (this.s2 != null) {
            double[] s2 = new double[this.s2.length];
            for (i = 0; i < this.s2.length; ++i) {
                s2[i] = this.s2[i].getValue();
            }
            this.s2Expr.setValue((ELContext)this.context, (Object)s2);
        }
        if (this.y != null) {
            y = new double[this.y.length];
            for (i = 0; i < this.y.length; ++i) {
                y[i] = this.y[i].getValue();
            }
            this.yExpr.setValue((ELContext)this.context, (Object)y);
        }
        if (this.w != null) {
            this.wExpr.setValue((ELContext)this.context, (Object)this.w.getValue());
        }
        if (this.time != null && this.time.getValue() != null) {
            this.timeExpr.setValue((ELContext)this.context, (Object)this.time.getValue());
        }
        if (this.I != null && this.I.getValue() != null) {
            this.intervalExpr.setValue((ELContext)this.context, (Object)this.I);
        }
        y = (double[])this.valueExpr.getValue((ELContext)this.context);
        for (i = 0; i < n; ++i) {
            this.y[i].setValue(y[i]);
        }
    }

    private void readObject(ObjectInputStream objIn) throws IOException, ClassNotFoundException {
        objIn.defaultReadObject();
        this.init();
    }
}

