/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.JAMS;
import jams.data.Attribute;
import java.util.ArrayList;
import java.util.List;

public class TSAggregator {
    public static final int MODE_SUM = 0;
    public static final int MODE_AVG = 1;
    private double[] values;
    private List<Attribute.Calendar> dates;
    private int mode;

    public TSAggregator(double[] values, List<Attribute.Calendar> dates, int mode) {
        this.dates = dates;
        this.values = values;
        this.mode = mode;
    }

    public Aggregate toMonthly() {
        return this.toTimeInterval(2);
    }

    public Aggregate toWeekly() {
        return this.toTimeInterval(3);
    }

    public double[] toSevenDaily() {
        int i;
        ArrayList<Double> result = new ArrayList<Double>();
        double sum = 0.0;
        double count = 1.0;
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            sum += this.values[i2];
            if (count % 7.0 == 0.0) {
                result.add(sum);
                sum = 0.0;
            }
            count += 1.0;
        }
        result.add(sum);
        double[] a = new double[result.size()];
        for (i = 0; i < result.size(); ++i) {
            a[i] = (Double)result.get(i);
        }
        if (this.mode == 1) {
            i = 0;
            while (i < result.size() - 1) {
                int n = i++;
                a[n] = a[n] / 7.0;
            }
        }
        int n = result.size() - 1;
        a[n] = a[n] / (count / 7.0);
        return a;
    }

    public Aggregate toTimeInterval(int timeField) {
        int i;
        ArrayList<Double> result = new ArrayList<Double>();
        ArrayList<Integer> counts = new ArrayList<Integer>();
        ArrayList<Integer> missings = new ArrayList<Integer>();
        Attribute.Calendar date = this.dates.get(0);
        double sum = 0.0;
        int count = 0;
        int missing = 0;
        Aggregate aggr = new Aggregate();
        aggr.dates.add(date);
        for (int i2 = 0; i2 < this.values.length; ++i2) {
            if (this.dates.get(i2).get(timeField) == date.get(timeField)) {
                if (this.values[i2] != JAMS.getMissingDataValue()) {
                    sum += this.values[i2];
                    ++count;
                    continue;
                }
                ++missing;
                continue;
            }
            result.add(sum);
            counts.add(count);
            missings.add(missing);
            if (this.values[i2] != JAMS.getMissingDataValue()) {
                sum = this.values[i2];
                count = 1;
                missing = 0;
            } else {
                sum = 0.0;
                count = 0;
                missing = 1;
            }
            date = this.dates.get(i2);
            aggr.dates.add(date);
        }
        result.add(sum);
        counts.add(count);
        double[] a = new double[result.size()];
        for (int i3 = 0; i3 < result.size(); ++i3) {
            a[i3] = (Double)result.get(i3);
        }
        int[] m = new int[missings.size()];
        for (i = 0; i < missings.size(); ++i) {
            m[i] = (Integer)missings.get(i);
        }
        if (this.mode == 1) {
            for (i = 0; i < counts.size(); ++i) {
                if (counts.get(i) == null) {
                    a[i] = JAMS.getMissingDataValue();
                    continue;
                }
                int n = i;
                a[n] = a[n] / (double)((Integer)counts.get(i)).intValue();
            }
        }
        aggr.values = a;
        aggr.missing = m;
        return aggr;
    }

    public class Aggregate {
        public double[] values;
        public int[] missing;
        public List<Attribute.Calendar> dates = new ArrayList<Attribute.Calendar>();
    }
}

