/*
 * Decompiled with CFR 0.152.
 */
package jams.components.aggregate;

import jams.JAMS;
import jams.data.Attribute;
import jams.model.JAMSComponent;
import jams.model.JAMSComponentDescription;
import jams.model.JAMSVarDescription;
import jams.model.VersionComments;

@JAMSComponentDescription(title="LongTermAggregation", author="Sven Kralisch", description="Calculates longterm aggregates, e.g. average daily temperature", date="2017-06-29", version="1.0_2")
@VersionComments(entries={@VersionComments.Entry(version="1.0_0", date="2017-06-29", comment="Initial version"), @VersionComments.Entry(version="1.0_1", comment="Some improvements"), @VersionComments.Entry(version="1.0_2", date="2018-09-10", comment="Some improvements")})
public class LongTermAggregation
extends JAMSComponent {
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Double[] inputAttribute;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Boolean[] calcAverage;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="Description")
    public Attribute.Calendar time;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="day (of year), week (of year), month (of year), year (overall aggregate), irregular (not implemented)")
    public Attribute.String targetUnit;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.READ, description="if targetUnit is \"irregular\"")
    public Attribute.TimeInterval targetInterval;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="Aggregation result")
    public Attribute.DoubleArray[] aggregate;
    @JAMSVarDescription(access=JAMSVarDescription.AccessType.WRITE, description="number of values")
    public Attribute.IntegerArray[] nValues;
    int[][] count;
    int field;

    public void init() {
        int maxn;
        if (this.targetUnit.getValue().equals("day")) {
            this.field = 6;
            maxn = 366;
            for (Attribute.DoubleArray da : this.aggregate) {
                da.setValue(new double[maxn]);
            }
        } else if (this.targetUnit.getValue().equals("week")) {
            this.field = 3;
            maxn = 53;
            for (Attribute.DoubleArray da : this.aggregate) {
                da.setValue(new double[maxn]);
            }
        } else if (this.targetUnit.getValue().equals("month")) {
            this.field = 2;
            maxn = 12;
            for (Attribute.DoubleArray da : this.aggregate) {
                da.setValue(new double[maxn]);
            }
        } else if (this.targetUnit.getValue().equals("year")) {
            this.field = 1;
            maxn = 1;
            for (Attribute.DoubleArray da : this.aggregate) {
                da.setValue(new double[maxn]);
            }
        } else if (this.targetUnit.getValue().equals("irregular")) {
            this.field = -1;
            maxn = 1;
            for (Attribute.DoubleArray da : this.aggregate) {
                da.setValue(new double[maxn]);
            }
        } else {
            this.field = 2;
            maxn = 12;
            for (Attribute.DoubleArray da : this.aggregate) {
                da.setValue(new double[maxn]);
            }
        }
        this.count = new int[this.inputAttribute.length][maxn];
    }

    public void run() {
        int i;
        if (this.field < 0) {
            for (i = 0; i < this.inputAttribute.length; ++i) {
                int[] nArray = this.count[i];
                nArray[0] = nArray[0] + 1;
            }
        } else {
            int index = this.time.get(this.field);
            if (this.field != 2) {
                --index;
            }
            if (this.field == 1) {
                index = 0;
            }
            for (int i2 = 0; i2 < this.inputAttribute.length; ++i2) {
                double result;
                if (this.inputAttribute[i2].getValue() == JAMS.getMissingDataValue()) continue;
                this.aggregate[i2].getValue()[index] = this.calcAverage[i2].getValue() ? (result = (this.aggregate[i2].getValue()[index] * (double)this.count[i2][index] + this.inputAttribute[i2].getValue()) / (double)(this.count[i2][index] + 1)) : (result = this.aggregate[i2].getValue()[index] + this.inputAttribute[i2].getValue());
                int[] nArray = this.count[i2];
                int n = index;
                nArray[n] = nArray[n] + 1;
            }
        }
        for (i = 0; i < this.nValues.length; ++i) {
            this.nValues[i].setValue(this.count[i]);
        }
    }

    public void cleanup() {
    }
}

