/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import ucar.nc2.iosp.bufr.tables.BufrTables;
import ucar.nc2.util.TableParser;

public class CommonCodeTables {
    private static String[] tableC1 = null;
    private static String[] tableA = null;
    private static Map<Integer, String> tableC12 = null;
    private static Map<Integer, String> tableC13 = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initTableA() {
        String location = "/resources/bufrTables/wmo/TableA-11-2008.txt";
        InputStream ios = BufrTables.class.getResourceAsStream(location);
        tableA = new String[256];
        try {
            List<TableParser.Record> recs = TableParser.readTable(ios, "3i,60", 255);
            for (TableParser.Record record : recs) {
                int no = (Integer)record.get(0);
                String name = (String)record.get(1);
                CommonCodeTables.tableA[no] = name = name.trim();
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initC1() {
        String location = "/resources/bufrTables/wmo/wmoTableC1.txt";
        InputStream ios = BufrTables.class.getResourceAsStream(location);
        tableC1 = new String[256];
        try {
            String prev = null;
            List<TableParser.Record> recs = TableParser.readTable(ios, "8,13i,120", 500);
            for (TableParser.Record record : recs) {
                int no = (Integer)record.get(1);
                String name = (String)record.get(2);
                CommonCodeTables.tableC1[no] = (name = name.trim()).equals(")") ? prev : name;
                prev = name;
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initC12() {
        String location = "/resources/bufrTables/wmo/wmoTableC12.txt";
        InputStream ios = BufrTables.class.getResourceAsStream(location);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, Charset.forName("UTF-8")));
        tableC12 = new HashMap<Integer, String>(200);
        int count = 0;
        int center_id = 0;
        int subcenter_id = 0;
        try {
            while (true) {
                String line = dataIS.readLine();
                ++count;
                if (line == null) {
                    break;
                }
                if (line.startsWith("#")) continue;
                String[] flds = line.split("[ \t]+");
                if (flds[0].startsWith("00")) {
                    center_id = Integer.parseInt(flds[0]);
                    continue;
                }
                subcenter_id = Integer.parseInt(flds[1]);
                StringBuffer sbuff = new StringBuffer();
                for (int i = 2; i < flds.length; ++i) {
                    if (i > 2) {
                        sbuff.append(" ");
                    }
                    sbuff.append(flds[i]);
                }
                int subid = center_id << 16 + subcenter_id;
                tableC12.put(subid, sbuff.toString());
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initC13() {
        String location = "/resources/bufrTables/wmo/wmoTableC13.txt";
        InputStream ios = BufrTables.class.getResourceAsStream(location);
        BufferedReader dataIS = new BufferedReader(new InputStreamReader(ios, Charset.forName("UTF-8")));
        tableC13 = new HashMap<Integer, String>(200);
        int count = 0;
        int cat = 0;
        int subcat = 0;
        try {
            while (true) {
                String line = dataIS.readLine();
                ++count;
                if (line == null) {
                    break;
                }
                if (line.startsWith("#")) continue;
                String[] flds = line.split("[ \t]+");
                if (flds[0].length() > 0) {
                    cat = Integer.parseInt(flds[0]);
                    continue;
                }
                subcat = Integer.parseInt(flds[1]);
                StringBuffer sbuff = new StringBuffer();
                for (int i = 2; i < flds.length; ++i) {
                    if (i > 2) {
                        sbuff.append(" ");
                    }
                    sbuff.append(flds[i]);
                }
                int subid = cat << 16 + subcat;
                tableC13.put(subid, sbuff.toString());
            }
        }
        catch (IOException ioe) {
        }
        finally {
            if (ios != null) {
                try {
                    ios.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    public static String getCenterName(int center_id) {
        if (tableC1 == null) {
            CommonCodeTables.initC1();
        }
        String result = center_id < 0 || center_id > 255 ? null : tableC1[center_id];
        return result != null ? result : "Unknown center=" + center_id;
    }

    public static String getSubCenterName(int center_id, int subcenter_id) {
        if (tableC12 == null) {
            CommonCodeTables.initC12();
        }
        int subid = center_id << 16 + subcenter_id;
        return tableC12.get(subid);
    }

    public static String getDataSubcategoy(int cat, int subcat) {
        if (tableC13 == null) {
            CommonCodeTables.initC13();
        }
        int subid = cat << 16 + subcat;
        return tableC13.get(subid);
    }

    public static String getDataCategory(int cat) {
        if (tableA == null) {
            CommonCodeTables.initTableA();
        }
        String result = cat < 0 || cat > 255 ? null : tableA[cat];
        return result != null ? result : "Unknown category=" + cat;
    }

    public static void main(String[] arg) throws IOException {
        CommonCodeTables.initTableA();
    }
}

