/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.conv;

import java.util.NoSuchElementException;
import ucar.ma2.ArrayByte;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordSysBuilder;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.VariableEnhanced;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.ProjectionPointImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Mercator;

public class AWIPSsatConvention
extends CoordSysBuilder {
    private static final boolean debugProj = false;
    private ProjectionCT projCT = null;
    private double startx;
    private double starty;
    private double dx;
    private double dy;

    public static boolean isMine(NetcdfFile ncfile) {
        return null != ncfile.findGlobalAttribute("projName") && null != ncfile.findGlobalAttribute("lon00") && null != ncfile.findGlobalAttribute("lat00") && null != ncfile.findGlobalAttribute("lonNxNy") && null != ncfile.findGlobalAttribute("latNxNy") && null != ncfile.findGlobalAttribute("centralLon") && null != ncfile.findGlobalAttribute("centralLat") && null != ncfile.findDimension("x") && null != ncfile.findDimension("y") && null != ncfile.findVariable("image");
    }

    public AWIPSsatConvention() {
        this.conventionName = "AWIPS-Sat";
    }

    @Override
    public void augmentDataset(NetcdfDataset ds, CancelTask cancelTask) {
        if (null != ds.findVariable("x")) {
            return;
        }
        Dimension dimx = ds.findDimension("x");
        int nx = dimx.getLength();
        Dimension dimy = ds.findDimension("y");
        int ny = dimy.getLength();
        String projName = ds.findAttValueIgnoreCase(null, "projName", "none");
        if (projName.equalsIgnoreCase("LAMBERT_CONFORMAL")) {
            this.projCT = this.makeLCProjection(ds, projName, nx, ny);
        }
        if (projName.equalsIgnoreCase("MERCATOR")) {
            this.projCT = this.makeMercatorProjection(ds, projName, nx, ny);
        }
        ds.addCoordinateAxis(this.makeXCoordAxis(ds, nx, "x"));
        ds.addCoordinateAxis(this.makeYCoordAxis(ds, ny, "y"));
        Variable datav = ds.findVariable("image");
        String long_name = ds.findAttValueIgnoreCase(null, "channel", null);
        if (null != long_name) {
            datav.addAttribute(new Attribute("long_name", long_name));
        }
        ArrayByte.D1 missing_values = new ArrayByte.D1(2);
        missing_values.set(0, (byte)0);
        missing_values.set(1, (byte)-127);
        datav.addAttribute(new Attribute("missing_values", missing_values));
        datav.addAttribute(new Attribute("_Unsigned", "true"));
        if (this.projCT != null) {
            VariableDS v = this.makeCoordinateTransformVariable(ds, this.projCT);
            v.addAttribute(new Attribute("_CoordinateAxes", "x y"));
            ds.addVariable(null, v);
        }
        ds.finish();
    }

    @Override
    protected AxisType getAxisType(NetcdfDataset ds, VariableEnhanced ve) {
        Variable v = (Variable)((Object)ve);
        String vname = v.getShortName();
        if (vname.equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        Dimension dim = v.getDimension(0);
        if (dim != null && dim.getName().equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        String unit = ve.getUnitsString();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return AxisType.GeoZ;
    }

    @Override
    protected void makeCoordinateTransforms(NetcdfDataset ds) {
        if (this.projCT != null) {
            CoordSysBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName());
            vp.isCoordinateTransform = true;
            vp.ct = this.projCT;
        }
        super.makeCoordinateTransforms(ds);
    }

    private ProjectionCT makeLCProjection(NetcdfDataset ds, String name, int nx, int ny) throws NoSuchElementException {
        double centralLat = this.findAttributeDouble(ds, "centralLat");
        double centralLon = this.findAttributeDouble(ds, "centralLon");
        double rotation = this.findAttributeDouble(ds, "rotation");
        LambertConformal proj = new LambertConformal(rotation, centralLon, centralLat, centralLat);
        double lat0 = this.findAttributeDouble(ds, "lat00");
        double lon0 = this.findAttributeDouble(ds, "lon00");
        ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj((LatLonPoint)new LatLonPointImpl(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        double latN = this.findAttributeDouble(ds, "latNxNy");
        double lonN = this.findAttributeDouble(ds, "lonNxNy");
        ProjectionPointImpl end = (ProjectionPointImpl)proj.latLonToProj((LatLonPoint)new LatLonPointImpl(latN, lonN));
        this.dx = (end.getX() - this.startx) / (double)nx;
        this.dy = (end.getY() - this.starty) / (double)ny;
        return new ProjectionCT(name, "FGDC", (ProjectionImpl)proj);
    }

    private ProjectionCT makeMercatorProjection(NetcdfDataset ds, String name, int nx, int ny) throws NoSuchElementException {
        double centralLat = this.findAttributeDouble(ds, "centralLat");
        double centralLon = this.findAttributeDouble(ds, "centralLon");
        double latDxDy = this.findAttributeDouble(ds, "latDxDy");
        double lonDxDy = this.findAttributeDouble(ds, "lonDxDy");
        Mercator proj = new Mercator(lonDxDy, latDxDy);
        double lat0 = this.findAttributeDouble(ds, "lat00");
        double lon0 = this.findAttributeDouble(ds, "lon00");
        ProjectionPointImpl start = (ProjectionPointImpl)proj.latLonToProj((LatLonPoint)new LatLonPointImpl(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        double latN = this.findAttributeDouble(ds, "latNxNy");
        double lonN = this.findAttributeDouble(ds, "lonNxNy");
        ProjectionPointImpl end = (ProjectionPointImpl)proj.latLonToProj((LatLonPoint)new LatLonPointImpl(latN, lonN));
        this.dx = (end.getX() - this.startx) / (double)nx;
        this.dy = (end.getY() - this.starty) / (double)ny;
        return new ProjectionCT(name, "FGDC", (ProjectionImpl)proj);
    }

    private CoordinateAxis makeXCoordAxis(NetcdfDataset ds, int nx, String xname) {
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, xname, DataType.DOUBLE, xname, "km", "x on projection");
        ds.setValues(v, nx, this.startx, this.dx);
        this.parseInfo.format("Created X Coordinate Axis = ", new Object[0]);
        v.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("\n", new Object[0]);
        return v;
    }

    private CoordinateAxis makeYCoordAxis(NetcdfDataset ds, int ny, String yname) {
        CoordinateAxis1D v = new CoordinateAxis1D(ds, null, yname, DataType.DOUBLE, yname, "km", "y on projection");
        ds.setValues(v, ny, this.starty, this.dy);
        this.parseInfo.format("Created Y Coordinate Axis = ", new Object[0]);
        v.getNameAndDimensions(this.parseInfo, true, false);
        this.parseInfo.format("\n", new Object[0]);
        return v;
    }

    private double findAttributeDouble(NetcdfDataset ds, String attname) {
        Attribute att = ds.findGlobalAttributeIgnoreCase(attname);
        return att.getNumericValue().doubleValue();
    }
}

