/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib1;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import net.jcip.annotations.Immutable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.GribPds;
import ucar.grib.grib1.GribPDSLevel;

@Immutable
public final class Grib1Pds
extends GribPds {
    private static Logger log = LoggerFactory.getLogger(Grib1Pds.class);
    private final int length;
    private final long refTime;
    private final long validTime;
    private GribPDSLevel level;

    public Grib1Pds(byte[] input) throws IOException {
        this(input, Calendar.getInstance());
    }

    public Grib1Pds(byte[] input, Calendar cal) throws IOException {
        this.input = input;
        this.length = GribNumbers.int3(this.getOctet(1), this.getOctet(2), this.getOctet(3));
        this.level = new GribPDSLevel(this.getOctet(10), this.getOctet(11), this.getOctet(12));
        int century = this.getOctet(25) - 1;
        if (century == -1) {
            century = 20;
        }
        int year = this.getOctet(13);
        int month = this.getOctet(14);
        int day = this.getOctet(15);
        int hour = this.getOctet(16);
        int minute = this.getOctet(17);
        cal.clear();
        cal.setTimeZone(TimeZone.getTimeZone("GMT"));
        cal.set(16, 0);
        cal.set(century * 100 + year, month - 1, day, hour, minute, 0);
        this.refTime = cal.getTimeInMillis();
        int type = 1;
        int factor = 1;
        switch (this.getTimeUnit()) {
            case 0: {
                type = 12;
                break;
            }
            case 1: {
                type = 11;
                break;
            }
            case 2: {
                type = 11;
                factor = 24;
                break;
            }
            case 3: {
                type = 2;
                break;
            }
            case 4: {
                type = 1;
                break;
            }
            case 5: {
                type = 1;
                factor = 10;
                break;
            }
            case 6: {
                type = 1;
                factor = 30;
                break;
            }
            case 7: {
                type = 1;
                factor = 100;
                break;
            }
            case 10: {
                type = 11;
                factor = 3;
                break;
            }
            case 11: {
                type = 11;
                factor = 6;
                break;
            }
            case 12: {
                type = 11;
                factor = 12;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown timeUnit= " + this.getTimeUnit());
            }
        }
        cal.add(type, factor * this.getForecastTime());
        this.validTime = cal.getTimeInMillis();
    }

    public final int getSection() {
        return 1;
    }

    public final int getLength() {
        return this.length;
    }

    public final int getParameterTableVersion() {
        return this.getOctet(4);
    }

    public final int getCenter() {
        return this.getOctet(5);
    }

    @Override
    public final int getGenProcessId() {
        return this.getOctet(6);
    }

    public final int getGridId() {
        return this.getOctet(7);
    }

    public final boolean gdsExists() {
        return (this.getOctet(8) & 0x80) == 128;
    }

    public final boolean bmsExists() {
        return (this.getOctet(8) & 0x40) == 64;
    }

    @Override
    public final int getParameterNumber() {
        return this.getOctet(9);
    }

    @Override
    public final int getLevelType1() {
        return this.level.getIndex();
    }

    public final String getLevelName() {
        return this.level.getName();
    }

    @Override
    public final double getLevelValue1() {
        return this.level.getValue1();
    }

    @Override
    public final int getLevelType2() {
        return 255;
    }

    @Override
    public final double getLevelValue2() {
        return this.level.getValue2();
    }

    @Override
    public final long getReferenceTime() {
        return this.refTime;
    }

    @Override
    public final int getTimeUnit() {
        return this.getOctet(18);
    }

    public final int getP1() {
        if (this.getTimeRangeIndicator() == 10) {
            return GribNumbers.int2(this.getOctet(19), this.getOctet(20));
        }
        return this.getOctet(19);
    }

    public final int getP2() {
        if (this.getTimeRangeIndicator() == 10) {
            return 0;
        }
        return this.getOctet(20);
    }

    public final int getTimeRangeIndicator() {
        return this.getOctet(21);
    }

    @Override
    public final Date getForecastDate() {
        return new Date(this.validTime);
    }

    @Override
    public final int getForecastTime() {
        switch (this.getTimeRangeIndicator()) {
            case 0: {
                return this.getP1();
            }
            case 1: {
                return 0;
            }
            case 2: {
                return this.getP2();
            }
            case 3: {
                return this.getP2();
            }
            case 4: {
                return this.getP2();
            }
            case 5: {
                return this.getP2();
            }
            case 6: {
                return -this.getP2();
            }
            case 7: {
                return this.getP2();
            }
            case 10: {
                return this.getP1();
            }
            case 51: {
                return this.getP2();
            }
            case 113: {
                return this.getP1();
            }
            case 123: 
            case 124: {
                return 0;
            }
        }
        log.error("PDS: Time Range Indicator " + this.getTimeRangeIndicator() + " is not yet supported");
        return -9999;
    }

    @Override
    public final boolean isInterval() {
        int code = this.getTimeRangeIndicator();
        return code == 2 || code == 3 || code == 4 || code == 5 || code == 6 || code == 7;
    }

    @Override
    public long getIntervalTimeEnd() {
        return -1L;
    }

    @Override
    public int[] getForecastTimeInterval() {
        if (!this.isInterval()) {
            return null;
        }
        int[] interval = new int[]{this.getP1(), this.getP2()};
        return interval;
    }

    @Override
    public int[] getForecastTimeInterval(int wantTimeUnit) {
        return this.getForecastTimeInterval();
    }

    @Override
    public int getStatisticalProcessType() {
        switch (this.getTimeRangeIndicator()) {
            case 3: 
            case 6: 
            case 7: 
            case 113: 
            case 115: 
            case 117: 
            case 123: {
                return 0;
            }
            case 4: 
            case 114: 
            case 116: 
            case 124: {
                return 1;
            }
            case 5: {
                return 4;
            }
            case 51: {
                return 0;
            }
            case 118: {
                return 7;
            }
            case 119: 
            case 125: {
                return 7;
            }
        }
        return -1;
    }

    public final int getNumberIncludedInAverage() {
        return GribNumbers.int2(this.getOctet(22), this.getOctet(23));
    }

    public final int getNumberMissingInAverage() {
        return this.getOctet(24);
    }

    public final int getSubCenter() {
        return this.getOctet(26);
    }

    public final int getDecimalScale() {
        return GribNumbers.int2(this.getOctet(27), this.getOctet(28));
    }

    public final int getExtension() {
        return this.getOctet(41);
    }

    public final int getEcmwfClass() {
        switch (this.getCenter()) {
            case 98: {
                return this.getOctet(42);
            }
        }
        return -9999;
    }

    public final int getID() {
        switch (this.getCenter()) {
            case 7: 
            case 8: 
            case 9: {
                return this.getOctet(43);
            }
        }
        return -9999;
    }

    public final int getStream() {
        return GribNumbers.int2(this.getOctet(44), this.getOctet(45));
    }

    public final int getProductID() {
        return this.getOctet(44);
    }

    public final int getSpatialorProbability() {
        return this.getOctet(45);
    }

    public final int getProbabilityProduct() {
        if (this.length > 45 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return this.getOctet(46);
        }
        return -9999;
    }

    @Override
    public final int getProbabilityType() {
        if (this.length > 46 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return this.getOctet(47);
        }
        return -9999;
    }

    @Override
    public boolean isPercentile() {
        return false;
    }

    @Override
    public int getPercentileValue() {
        return -1;
    }

    @Override
    public final boolean isEnsemble() {
        if (this.getCenter() == 7 && this.length >= 44 && this.getOctet(41) == 1 && this.getOctet(42) < 4) {
            return true;
        }
        return this.getCenter() == 98 && this.length > 40 && this.getOctet(41) != 0;
    }

    @Override
    public final int getPerturbationType() {
        if (!this.isEnsemble()) {
            return -9999;
        }
        if (this.getCenter() == 7) {
            return this.getOctet(42);
        }
        if (this.getCenter() == 98) {
            return this.getOctet(43);
        }
        return -9999;
    }

    @Override
    public final int getPerturbationNumber() {
        if (!this.isEnsemble()) {
            return -9999;
        }
        if (this.getCenter() == 7) {
            int type = this.getOctet(42);
            int id = this.getOctet(43);
            if (type == 1) {
                return 0;
            }
            if (type == 2) {
                return id;
            }
            if (type == 3) {
                return 5 + id;
            }
        }
        if (this.getCenter() == 98) {
            return this.getOctet(50);
        }
        return -9999;
    }

    @Override
    public int getNumberEnsembleForecasts() {
        return 0;
    }

    @Override
    public boolean isEnsembleDerived() {
        return false;
    }

    @Override
    public boolean isProbability() {
        return false;
    }

    @Override
    public double getProbabilityLowerLimit() {
        return Double.NaN;
    }

    @Override
    public double getProbabilityUpperLimit() {
        return Double.NaN;
    }

    public final int getType() {
        switch (this.getCenter()) {
            case 7: 
            case 8: 
            case 9: {
                return this.getOctet(42);
            }
            case 98: {
                return this.getOctet(43);
            }
        }
        return -9999;
    }

    public final float getValueLowerLimit() {
        if (this.length > 50 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return GribNumbers.float4(this.getOctet(48), this.getOctet(49), this.getOctet(50), this.getOctet(51));
        }
        return -9999.0f;
    }

    public final float getValueUpperLimit() {
        if (this.length > 54 && (this.getParameterNumber() == 191 || this.getParameterNumber() == 192)) {
            return GribNumbers.float4(this.getOctet(52), this.getOctet(53), this.getOctet(54), this.getOctet(55));
        }
        return -9999.0f;
    }

    public final int getNumberForecasts() {
        switch (this.getCenter()) {
            case 7: 
            case 8: 
            case 9: {
                if (this.length > 60 && (this.getType() == 4 || this.getType() == 5)) {
                    return this.getOctet(61);
                }
                return -9999;
            }
            case 98: {
                if (this.getExtension() != 30) break;
                return this.getOctet(51);
            }
        }
        return -9999;
    }

    public final int getSizeClusters() {
        if (this.length > 61 && (this.getType() == 4 || this.getType() == 5)) {
            return this.getOctet(62);
        }
        return -9999;
    }

    public final int getNumberClusters() {
        if (this.length > 62 && (this.getType() == 4 || this.getType() == 5)) {
            return this.getOctet(63);
        }
        return -9999;
    }

    public final int getMethod() {
        if (this.length > 63 && (this.getType() == 4 || this.getType() == 5)) {
            return this.getOctet(64);
        }
        return -9999;
    }

    public final float getNorthLatitude() {
        if (this.length > 66 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getOctet(65), this.getOctet(66), this.getOctet(67)) / 1000;
        }
        return -9999.0f;
    }

    public final float getSouthLatitude() {
        if (this.length > 69 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getOctet(68), this.getOctet(69), this.getOctet(70)) / 1000;
        }
        return -9999.0f;
    }

    public final float getEastLongitude() {
        if (this.length > 72 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getOctet(71), this.getOctet(72), this.getOctet(73)) / 1000;
        }
        return -9999.0f;
    }

    public final float getWestLongitude() {
        if (this.length > 75 && (this.getType() == 4 || this.getType() == 5)) {
            return GribNumbers.int3(this.getOctet(74), this.getOctet(75), this.getOctet(76)) / 1000;
        }
        return -9999.0f;
    }

    public final int[] getMembership() {
        if (this.length > 85 && this.getType() == 4) {
            int[] member = new int[10];
            int idx = 77;
            for (int i = 0; i < 10; ++i) {
                member[i] = this.getOctet(idx++);
            }
            return member;
        }
        return null;
    }
}

