/*
 * Decompiled with CFR 0.152.
 */
package cci;

import cci.CCIndex;
import jams.ErrorCatchingRunnable;
import jams.JAMS;
import jams.SystemProperties;
import jams.gui.HelpDlg;
import jams.gui.WorkerDlg;
import jams.gui.input.InputComponent;
import jams.gui.input.InputComponentFactory;
import jams.gui.tools.GUIHelper;
import jams.io.ParameterProcessor;
import jams.meta.HelpComponent;
import jams.model.JAMSFullModelState;
import jams.model.Model;
import jams.runtime.JAMSRuntime;
import jams.runtime.StandardRuntime;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import netcdfTool2.DatasetViewer;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class CCILauncher
extends JFrame {
    protected static final String CONFIG_FILE_NAME = "config.txt";
    protected static final String BASE_TITLE = "CDITool";
    private static final int BUTTON_SIZE = 20;
    private Map<InputComponent, Element> inputMap;
    private Map<InputComponent, String> attributeNameMap;
    private Map<InputComponent, JScrollPane> groupMap;
    protected Document modelDocument = null;
    private JTabbedPane tabbedPane = new JTabbedPane();
    private SystemProperties properties;
    private JButton runButton;
    private HelpDlg helpDlg;
    protected String initialModelDocString = "";
    protected File loadPath;
    protected JAMSRuntime runtime;
    private Runnable modelLoading;
    private WorkerDlg loadModelDlg;
    private Font titledBorderFont;
    private Action runModelAction;
    private JToolBar toolBar;
    protected JAMSFullModelState state = null;
    private Observer observer;
    private DatasetViewer viewer;
    private Box statusPrecip;
    private Box statusTmean;
    private Box statusTmin;
    private Box statusTmax;
    private static List<Image> appIcons;
    private JTextField modelNameField;
    private File precipFile;
    private File tmaxFile;
    private File tminFile;
    private File tmeanFile;

    public CCILauncher(Window parent, SystemProperties properties) {
        this.properties = properties;
        this.init();
    }

    public CCILauncher(Window parent, SystemProperties properties, Document modelDocument) {
        this(parent, properties);
        this.loadModelDefinition(modelDocument);
    }

    public CCILauncher(Window parent, SystemProperties properties, Document modelDocument, File loadPath) {
        this(parent, properties, modelDocument);
        this.loadPath = loadPath;
    }

    protected void loadModelDefinition(Document modelDocument) {
        this.modelDocument = modelDocument;
        this.fillAttributes(this.getModelDocument());
        this.fillTabbedPane(modelDocument);
    }

    protected void init() throws HeadlessException, DOMException, NumberFormatException {
        this.modelLoading = new ErrorCatchingRunnable(){

            @Override
            public void safeRun() {
                if (CCILauncher.this.state != null) {
                    Model model = CCILauncher.this.state.getModel();
                    CCILauncher.this.runtime = model.getRuntime();
                    return;
                }
                if (!CCILauncher.this.verifyInputs()) {
                    CCILauncher.this.runtime = null;
                    return;
                }
                CCILauncher.this.updateProperties();
                Document modelDocCopy = (Document)CCILauncher.this.getModelDocument().cloneNode(true);
                String defaultWorkspacePath = null;
                if (Boolean.parseBoolean(CCILauncher.this.properties.getProperty("defaultworkspace")) && CCILauncher.this.loadPath != null) {
                    defaultWorkspacePath = CCILauncher.this.loadPath.getParent();
                }
                CCILauncher.this.writeModelConfig();
                CCILauncher.this.runtime = new StandardRuntime(CCILauncher.this.getProperties());
                CCILauncher.this.runtime.addInfoLogObserver(new Observer(){

                    @Override
                    public void update(Observable obs, Object obj) {
                        CCILauncher.this.processInfoLog(obj.toString());
                    }
                });
                CCILauncher.this.runtime.addErrorLogObserver(new Observer(){

                    @Override
                    public void update(Observable obs, Object obj) {
                        CCILauncher.this.processErrorLog(obj.toString());
                    }
                });
                CCILauncher.this.runtime.loadModel(modelDocCopy, defaultWorkspacePath, CCILauncher.this.loadPath.getAbsolutePath());
                CCILauncher.this.runtime.getFrame().setIconImages(appIcons);
            }
        };
        this.runModelAction = new AbstractAction(CCIndex.i18n("Start_analysis")){

            @Override
            public void actionPerformed(ActionEvent e) {
                Thread t = new Thread(){

                    @Override
                    public void run() {
                        CCILauncher.this.runModel();
                        Runtime.getRuntime().gc();
                    }
                };
                t.start();
            }
        };
        this.loadModelDlg = new WorkerDlg((Window)this, JAMS.i18n("Model_Setup"));
        this.titledBorderFont = (Font)UIManager.getDefaults().get("TitledBorder.font");
        int fontSize = this.titledBorderFont.getSize();
        if (this.titledBorderFont.getStyle() == 1) {
            fontSize += 2;
        }
        this.titledBorderFont = new Font(this.titledBorderFont.getName(), 1, fontSize);
        this.helpDlg = new HelpDlg(this);
        this.setLocationByPlatform(true);
        this.setLayout(new BorderLayout());
        int width = Integer.parseInt(this.getProperties().getProperty("guiconfigwidth", "600"));
        int height = Integer.parseInt(this.getProperties().getProperty("guiconfigheight", "400"));
        this.setPreferredSize(new Dimension(width, height));
        this.setDefaultCloseOperation(0);
        this.setIconImages(CCILauncher.getAppIcons());
        this.setTitle(BASE_TITLE);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                CCILauncher.this.writeModelConfig();
                CCILauncher.this.exit();
            }
        });
        this.runButton = new JButton(this.runModelAction);
        this.runButton.setText("");
        this.runButton.setToolTipText(CCIndex.i18n("Start_analysis"));
        this.runButton.setIcon(new ImageIcon(this.getClass().getResource("/resources/images/ModelRun.png")));
        this.runButton.setEnabled(false);
        this.tabbedPane.setTabPlacement(2);
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.toolBar = new JToolBar();
        this.toolBar.setPreferredSize(new Dimension(0, 40));
        this.toolBar.add(this.runButton);
        this.getContentPane().add((Component)this.toolBar, "North");
        this.pack();
    }

    protected void writeModelConfig() {
        if (this.loadPath == null) {
            return;
        }
        try {
            File file = new File(this.loadPath.getParentFile(), CONFIG_FILE_NAME);
            Properties modelProperties = new Properties();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            modelProperties.load(is);
            String modelName = this.modelNameField.getText().trim();
            if (modelName.isEmpty()) {
                modelName = "current";
            }
            modelProperties.setProperty("outputDataDirectory", modelName);
            BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(file));
            modelProperties.store(os, "JAMS workspace configuration");
        }
        catch (IOException ioe) {
            this.runtime.handle(ioe);
        }
    }

    private String getOutputDataDirectory() {
        try {
            File file = new File(this.loadPath.getParentFile(), CONFIG_FILE_NAME);
            Properties modelProperties = new Properties();
            BufferedInputStream is = new BufferedInputStream(new FileInputStream(file));
            modelProperties.load(is);
            String modelName = modelProperties.getProperty("outputDataDirectory");
            if (modelName == null || modelName.equals("current")) {
                modelName = "";
            }
            return modelName;
        }
        catch (IOException ioe) {
            this.runtime.handle(ioe);
            return null;
        }
    }

    public static List<Image> getAppIcons() {
        if (appIcons == null) {
            appIcons = new ArrayList<Image>();
            appIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/ccindex.png")).getImage().getScaledInstance(16, 16, 4));
            appIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/ccindex.png")).getImage().getScaledInstance(32, 32, 4));
            appIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/ccindex.png")).getImage().getScaledInstance(48, 48, 4));
            appIcons.add(new ImageIcon(ClassLoader.getSystemResource("resources/images/ccindex.png")).getImage().getScaledInstance(256, 256, 4));
        }
        return appIcons;
    }

    protected void processInfoLog(String logText) {
    }

    protected void processErrorLog(String logText) {
    }

    protected boolean verifyInputs() {
        return this.verifyInputs(true);
    }

    protected boolean verifyInputs(boolean runModel) {
        for (InputComponent ic : this.getInputMap().keySet()) {
            if (ic.verify()) continue;
            this.tabbedPane.setSelectedComponent(this.getGroupMap().get(ic));
            ic.setMarked(true);
            String info = "";
            if (runModel) {
                info = JAMS.i18n("_Stopping_model_execution.");
            }
            if (ic.getErrorCode() == -2) {
                GUIHelper.showErrorDlg(this, JAMS.i18n("Selected_value_out_of_range!") + info, JAMS.i18n("Range_error"));
            } else {
                GUIHelper.showErrorDlg(this, JAMS.i18n("Invalid_value_found!") + info, JAMS.i18n("Format_error"));
            }
            ic.setMarked(false);
            return false;
        }
        return true;
    }

    private JLabel getFileStatusLabel(File file) {
        String iconName = file.exists() ? "/resources/images/ok_button.png" : "/resources/images/not_ok_button.png";
        JLabel iconLabel = new JLabel();
        iconLabel.setIcon(new ImageIcon(this.getClass().getResource(iconName)));
        return iconLabel;
    }

    private void startObserver(final File dir) {
        if (!dir.exists()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    WatchService watchService = FileSystems.getDefault().newWatchService();
                    Path path = Paths.get(dir.getAbsolutePath(), new String[0]);
                    path.register(watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
                    boolean poll = true;
                    while (poll) {
                        WatchKey key = watchService.take();
                        for (WatchEvent<?> event : key.pollEvents()) {
                            File file = new File(dir, event.context().toString());
                            if (file.getName().equals("precip.dat")) {
                                CCILauncher.this.statusPrecip.remove(2);
                                CCILauncher.this.statusPrecip.add((Component)CCILauncher.this.getFileStatusLabel(file), 2);
                                CCILauncher.this.statusPrecip.revalidate();
                                continue;
                            }
                            if (file.getName().equals("tmin.dat")) {
                                CCILauncher.this.statusTmin.remove(2);
                                CCILauncher.this.statusTmin.add((Component)CCILauncher.this.getFileStatusLabel(file), 2);
                                CCILauncher.this.statusTmin.revalidate();
                                continue;
                            }
                            if (file.getName().equals("tmean.dat")) {
                                CCILauncher.this.statusTmean.remove(2);
                                CCILauncher.this.statusTmean.add((Component)CCILauncher.this.getFileStatusLabel(file), 2);
                                CCILauncher.this.statusTmean.revalidate();
                                continue;
                            }
                            if (!file.getName().equals("tmax.dat")) continue;
                            CCILauncher.this.statusTmax.remove(2);
                            CCILauncher.this.statusTmax.add((Component)CCILauncher.this.getFileStatusLabel(file), 2);
                            CCILauncher.this.statusTmax.revalidate();
                        }
                        poll = key.reset();
                    }
                }
                catch (IOException ex) {
                    Logger.getLogger(CCILauncher.class.getName()).log(Level.SEVERE, null, ex);
                }
                catch (InterruptedException ex) {
                    Logger.getLogger(CCILauncher.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }.start();
    }

    protected void fillNetCDFPane(final File workspace) {
        this.precipFile = new File(workspace, "input/local/precip.dat");
        this.tmaxFile = new File(workspace, "input/local/tmax.dat");
        this.tminFile = new File(workspace, "input/local/tmin.dat");
        this.tmeanFile = new File(workspace, "input/local/tmean.dat");
        JPanel contentPanel = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        contentPanel.setLayout(gbl);
        JPanel scrollPanel = new JPanel();
        scrollPanel.add(contentPanel);
        JScrollPane scrollPane = new JScrollPane(scrollPanel);
        this.tabbedPane.insertTab(CCIndex.i18n("Data_Extraction"), null, scrollPane, null, 0);
        this.tabbedPane.setSelectedIndex(0);
        int row = 1;
        JPanel subgroupPanel = new JPanel(gbl);
        subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, "Model name", 0, 0, this.titledBorderFont));
        subgroupPanel.setPreferredSize(new Dimension(300, 100));
        GUIHelper.addGBComponent(contentPanel, gbl, subgroupPanel, 0, row++, 3, 1, 6, 2, 6, 2, 1.0, 1.0);
        this.modelNameField = new JTextField();
        this.modelNameField.setText(this.getOutputDataDirectory());
        this.modelNameField.setPreferredSize(new Dimension(250, 24));
        GUIHelper.addGBComponent(subgroupPanel, gbl, this.modelNameField, 1, row++, 1, 1, 0.0, 0.0);
        subgroupPanel = new JPanel(gbl);
        subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, "Precipitation", 0, 0, this.titledBorderFont));
        subgroupPanel.setPreferredSize(new Dimension(300, 100));
        GUIHelper.addGBComponent(contentPanel, gbl, subgroupPanel, 0, row++, 3, 1, 6, 2, 6, 2, 1.0, 1.0);
        this.statusPrecip = Box.createHorizontalBox();
        this.statusPrecip.add(new JLabel("Status: "));
        this.statusPrecip.add(Box.createHorizontalStrut(10));
        this.statusPrecip.add(this.getFileStatusLabel(this.precipFile));
        this.statusPrecip.add(Box.createHorizontalStrut(50));
        this.startObserver(new File(workspace, "input/local"));
        GUIHelper.addGBComponent(subgroupPanel, gbl, this.statusPrecip, 0, row, 1, 1, 0.0, 0.0);
        JButton ncdfToolButton = new JButton(CCIndex.i18n("Extract_Data"));
        GUIHelper.addGBComponent(subgroupPanel, gbl, ncdfToolButton, 1, row++, 1, 1, 0.0, 0.0);
        ncdfToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CCILauncher.this.viewer == null) {
                            CCILauncher.this.viewer = new DatasetViewer();
                            CCILauncher.this.viewer.initGUI(CCILauncher.getAppIcons(), CCILauncher.this.getProperties().getProperties());
                        }
                        CCILauncher.this.viewer.show(workspace, CCILauncher.this.precipFile, 0);
                    }
                });
            }
        });
        subgroupPanel = new JPanel(gbl);
        subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, "Mean Temperature", 0, 0, this.titledBorderFont));
        subgroupPanel.setPreferredSize(new Dimension(300, 100));
        GUIHelper.addGBComponent(contentPanel, gbl, subgroupPanel, 0, row++, 3, 1, 6, 2, 6, 2, 1.0, 1.0);
        this.statusTmean = Box.createHorizontalBox();
        this.statusTmean.add(new JLabel("Status: "));
        this.statusTmean.add(Box.createHorizontalStrut(10));
        this.statusTmean.add(this.getFileStatusLabel(this.tmeanFile));
        this.statusTmean.add(Box.createHorizontalStrut(50));
        GUIHelper.addGBComponent(subgroupPanel, gbl, this.statusTmean, 0, row, 1, 1, 0.0, 0.0);
        ncdfToolButton = new JButton(CCIndex.i18n("Extract_Data"));
        GUIHelper.addGBComponent(subgroupPanel, gbl, ncdfToolButton, 1, row++, 1, 1, 0.0, 0.0);
        ncdfToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CCILauncher.this.viewer == null) {
                            CCILauncher.this.viewer = new DatasetViewer();
                            CCILauncher.this.viewer.initGUI(CCILauncher.getAppIcons(), CCILauncher.this.getProperties().getProperties());
                        }
                        CCILauncher.this.viewer.show(workspace, CCILauncher.this.tmeanFile, 1);
                    }
                });
            }
        });
        subgroupPanel = new JPanel(gbl);
        subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, "Minimum Temperature", 0, 0, this.titledBorderFont));
        subgroupPanel.setPreferredSize(new Dimension(300, 100));
        GUIHelper.addGBComponent(contentPanel, gbl, subgroupPanel, 0, row++, 3, 1, 6, 2, 6, 2, 1.0, 1.0);
        this.statusTmin = Box.createHorizontalBox();
        this.statusTmin.add(new JLabel("Status: "));
        this.statusTmin.add(Box.createHorizontalStrut(10));
        this.statusTmin.add(this.getFileStatusLabel(this.tminFile));
        this.statusTmin.add(Box.createHorizontalStrut(50));
        GUIHelper.addGBComponent(subgroupPanel, gbl, this.statusTmin, 0, row, 1, 1, 0.0, 0.0);
        ncdfToolButton = new JButton(CCIndex.i18n("Extract_Data"));
        GUIHelper.addGBComponent(subgroupPanel, gbl, ncdfToolButton, 1, row++, 1, 1, 0.0, 0.0);
        ncdfToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CCILauncher.this.viewer == null) {
                            CCILauncher.this.viewer = new DatasetViewer();
                            CCILauncher.this.viewer.initGUI(CCILauncher.getAppIcons(), CCILauncher.this.getProperties().getProperties());
                        }
                        CCILauncher.this.viewer.show(workspace, CCILauncher.this.tminFile, 1);
                    }
                });
            }
        });
        subgroupPanel = new JPanel(gbl);
        subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, "Maximum Temperature", 0, 0, this.titledBorderFont));
        subgroupPanel.setPreferredSize(new Dimension(300, 100));
        GUIHelper.addGBComponent(contentPanel, gbl, subgroupPanel, 0, row++, 3, 1, 6, 2, 6, 2, 1.0, 1.0);
        this.statusTmax = Box.createHorizontalBox();
        this.statusTmax.add(new JLabel("Status: "));
        this.statusTmax.add(Box.createHorizontalStrut(10));
        this.statusTmax.add(this.getFileStatusLabel(this.tmaxFile));
        this.statusTmax.add(Box.createHorizontalStrut(50));
        GUIHelper.addGBComponent(subgroupPanel, gbl, this.statusTmax, 0, row, 1, 1, 0.0, 0.0);
        ncdfToolButton = new JButton(CCIndex.i18n("Extract_Data"));
        GUIHelper.addGBComponent(subgroupPanel, gbl, ncdfToolButton, 1, row++, 1, 1, 0.0, 0.0);
        ncdfToolButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (CCILauncher.this.viewer == null) {
                            CCILauncher.this.viewer = new DatasetViewer();
                            CCILauncher.this.viewer.initGUI(CCILauncher.getAppIcons(), CCILauncher.this.getProperties().getProperties());
                        }
                        CCILauncher.this.viewer.show(workspace, CCILauncher.this.tmaxFile, 1);
                    }
                });
            }
        });
    }

    protected void fillTabbedPane(Document doc) {
        HashMap<String, HashMap<String, Element>> componentHash = ParameterProcessor.getAttributeHash(this.getModelDocument());
        this.tabbedPane.removeAll();
        this.inputMap = new HashMap<InputComponent, Element>();
        this.attributeNameMap = new HashMap<InputComponent, String>();
        this.groupMap = new HashMap<InputComponent, JScrollPane>();
        Element root = doc.getDocumentElement();
        Element config = (Element)root.getElementsByTagName("launcher").item(0);
        if (config != null) {
            NodeList groups = config.getElementsByTagName("group");
            for (int i = 0; i < groups.getLength(); ++i) {
                JPanel contentPanel = new JPanel();
                GridBagLayout gbl = new GridBagLayout();
                contentPanel.setLayout(gbl);
                JPanel scrollPanel = new JPanel();
                scrollPanel.add(contentPanel);
                JScrollPane scrollPane = new JScrollPane(scrollPanel);
                Element groupElement = (Element)groups.item(i);
                int row = 1;
                NodeList groupChildNodes = groupElement.getChildNodes();
                for (int pindex = 0; pindex < groupChildNodes.getLength(); ++pindex) {
                    Node node = groupChildNodes.item(pindex);
                    if (node.getNodeName().equalsIgnoreCase("property")) {
                        Element propertyElement = (Element)node;
                        this.drawProperty(contentPanel, scrollPane, gbl, propertyElement, componentHash, row);
                        ++row;
                    }
                    if (!node.getNodeName().equalsIgnoreCase("subgroup")) continue;
                    Element subgroupElement = (Element)node;
                    String subgroupName = subgroupElement.getAttribute("name");
                    JPanel subgroupPanel = new JPanel(gbl);
                    subgroupPanel.setBorder(BorderFactory.createTitledBorder(null, subgroupName, 0, 0, this.titledBorderFont));
                    GUIHelper.addGBComponent(contentPanel, gbl, subgroupPanel, 0, ++row, 3, 1, 6, 2, 6, 2, 1.0, 1.0);
                    HelpComponent helpComponent = new HelpComponent(subgroupElement);
                    if (!helpComponent.isEmpty()) {
                        JPanel helpPanel = new JPanel();
                        HelpButton helpButton = this.createHelpButton(helpComponent);
                        helpPanel.add(helpButton);
                        GUIHelper.addGBComponent(contentPanel, gbl, helpPanel, 4, row, 1, 1, 1, 1, 1, 1, 1.0, 1.0);
                    }
                    ++row;
                    NodeList propertyNodes = subgroupElement.getElementsByTagName("property");
                    for (int kindex = 0; kindex < propertyNodes.getLength(); ++kindex) {
                        Element propertyElement = (Element)propertyNodes.item(kindex);
                        this.drawProperty(subgroupPanel, scrollPane, gbl, propertyElement, componentHash, row);
                        ++row;
                    }
                    row += 2;
                    ++row;
                }
                this.tabbedPane.addTab(groupElement.getAttribute("name"), scrollPane);
            }
        }
        this.runButton.setEnabled(true);
    }

    private void drawProperty(JPanel contentPanel, JScrollPane scrollPane, GridBagLayout gbl, Element property, HashMap<String, HashMap<String, Element>> componentHash, int row) {
        Element targetElement;
        String elementAttributeName;
        String componentName = property.getAttribute("component");
        String componentAttributeName = property.getAttribute("attribute");
        HashMap<String, Element> attributeMap = componentHash.get(componentName);
        if (attributeMap == null) {
            property.getParentNode().removeChild(property);
            GUIHelper.showInfoDlg(this, JAMS.i18n("Component_with_name_") + componentName + JAMS.i18n("_does_not_exist!") + JAMS.i18n("!_Removing_visual_editor!"), JAMS.i18n("Info"));
            return;
        }
        if (componentAttributeName.equals("%enable%")) {
            elementAttributeName = "enabled";
            targetElement = attributeMap.get(componentName);
        } else {
            elementAttributeName = "value";
            targetElement = attributeMap.get(componentAttributeName);
        }
        if (targetElement == null) {
            property.getParentNode().removeChild(property);
            GUIHelper.showInfoDlg(this, JAMS.i18n("Attribute_") + componentAttributeName + JAMS.i18n("_does_not_exist_in_component_") + componentName + JAMS.i18n("!_Removing_visual_editor!"), JAMS.i18n("Info"));
            return;
        }
        JLabel nameLabel = new JLabel(property.getAttribute("name"));
        nameLabel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        GUIHelper.addGBComponent(contentPanel, gbl, nameLabel, 0, row, 1, 1, 0.0, 0.0);
        try {
            String lenStr;
            String typeName = property.getAttribute("type");
            String prefix = typeName.startsWith("JAMS") ? "jams.data." : "jams.data.Attribute$";
            if (!typeName.startsWith(prefix)) {
                typeName = prefix + typeName;
            }
            InputComponent ic = InputComponentFactory.createInputComponent(Class.forName(typeName));
            StringTokenizer tok = new StringTokenizer(property.getAttribute("range"), ";");
            if (tok.countTokens() == 2) {
                String lower = tok.nextToken();
                String upper = tok.nextToken();
                ic.setRange(Double.parseDouble(lower), Double.parseDouble(upper));
            }
            if ((lenStr = property.getAttribute("length")) != null && lenStr.length() > 0) {
                ic.setLength(Integer.parseInt(lenStr));
            }
            ic.setHelpText(property.getAttribute("description"));
            ic.setValue(targetElement.getAttribute(elementAttributeName));
            this.getInputMap().put(ic, targetElement);
            this.getAttributeNameMap().put(ic, elementAttributeName);
            this.getGroupMap().put(ic, scrollPane);
            GUIHelper.addGBComponent(contentPanel, gbl, (Component)((Object)ic), 1, row, 2, 1, 1.0, 1.0);
        }
        catch (ClassNotFoundException ex) {
            ex.printStackTrace();
        }
        HelpComponent helpComponent = new HelpComponent(property);
        if (!helpComponent.isEmpty()) {
            HelpButton helpButton = this.createHelpButton(helpComponent);
            GUIHelper.addGBComponent(contentPanel, gbl, helpButton, 3, row, 1, 1, 1, 1, 1, 1, 1.0, 1.0);
        }
    }

    protected void fillAttributes(Document doc) {
        Element root = doc.getDocumentElement();
        this.setTitle("CDITool: " + root.getAttribute("name"));
        this.setHelpBaseUrl(root.getAttribute("helpbaseurl"));
    }

    protected void updateProperties() {
        for (InputComponent ic : this.getInputMap().keySet()) {
            Element element = this.getInputMap().get(ic);
            String attributeName = this.getAttributeNameMap().get(ic);
            if (!ic.verify()) continue;
            element.setAttribute(attributeName, ic.getValue());
        }
    }

    protected void exit() {
        this.setVisible(false);
        this.dispose();
    }

    public void setObserver(Observer observer) {
        this.observer = observer;
    }

    protected void runModel() {
        if (!this.precipFile.exists()) {
            GUIHelper.showErrorDlg(this, "Precipitation dataset missing. Please extract it before starting the analysis!", "Input data missing");
            return;
        }
        if (!this.tmaxFile.exists()) {
            GUIHelper.showErrorDlg(this, "Maximum temperature dataset missing. Please extract it before starting the analysis!", "Input data missing");
            return;
        }
        if (!this.tminFile.exists()) {
            GUIHelper.showErrorDlg(this, "Minimum temperature dataset missing. Please extract it before starting the analysis!", "Input data missing");
            return;
        }
        if (!this.tmeanFile.exists()) {
            GUIHelper.showErrorDlg(this, "Mean temperature dataset missing. Please extract it before starting the analysis!", "Input data missing");
            return;
        }
        this.loadModelDlg.setTask(this.modelLoading);
        this.loadModelDlg.execute();
        if (this.runtime == null) {
            return;
        }
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    if (CCILauncher.this.state == null) {
                        CCILauncher.this.runtime.runModel();
                    } else {
                        CCILauncher.this.runtime.resume(CCILauncher.this.state.getSmallModelState());
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    CCILauncher.this.runtime.handle(t);
                }
                CCILauncher.this.runtime = null;
                Runtime.getRuntime().gc();
            }
        };
        t.start();
    }

    public SystemProperties getProperties() {
        return this.properties;
    }

    public Map<InputComponent, Element> getInputMap() {
        return this.inputMap;
    }

    public Map<InputComponent, String> getAttributeNameMap() {
        return this.attributeNameMap;
    }

    public Map<InputComponent, JScrollPane> getGroupMap() {
        return this.groupMap;
    }

    protected Document getModelDocument() {
        return this.modelDocument;
    }

    protected String getHelpBaseUrl() {
        return this.helpDlg.getBaseUrl();
    }

    protected void setHelpBaseUrl(String helpBaseUrl) {
        this.helpDlg.setBaseUrl(helpBaseUrl);
    }

    protected HelpButton createHelpButton(HelpComponent helpComponent) {
        HelpButton helpButton = new HelpButton(helpComponent);
        helpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                HelpButton button = (HelpButton)e.getSource();
                button.showHelp();
            }
        });
        helpButton.setEnabled(true);
        return helpButton;
    }

    public void help(HelpComponent helpComponent) {
        this.helpDlg.load(helpComponent);
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public String getInitialModelDocString() {
        return this.initialModelDocString;
    }

    protected Action getRunModelAction() {
        return this.runModelAction;
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    protected class HelpButton
    extends JButton {
        HelpComponent helpComponent;

        public HelpButton(HelpComponent helpComponent) {
            this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.setPreferredSize(new Dimension(20, 20));
            this.getInsets().set(0, 0, 0, 0);
            this.setText("?");
            this.setFont(CCILauncher.this.titledBorderFont);
            this.setToolTipText(JAMS.i18n("Help"));
            this.helpComponent = helpComponent;
        }

        public void showHelp() {
            CCILauncher.this.help(this.helpComponent);
        }
    }
}

