/*
 * Decompiled with CFR 0.152.
 */
package cci;

import cci.Version;
import jams.JAMS;
import jams.tools.FileTools;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URL;
import java.util.Properties;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class AboutDlg
extends JDialog {
    private Image img;

    public AboutDlg(Frame owner) {
        super(owner);
        this.getContentPane().setLayout(new FlowLayout(1, 0, 0));
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        URL imgURL = ClassLoader.getSystemResource("resources/images/ccindex_splash.png");
        if (imgURL != null) {
            this.img = new ImageIcon(imgURL).getImage();
        }
        int x = this.img.getWidth(null);
        int y = this.img.getHeight(null);
        String gplText = "";
        String contribText = "";
        String versionText = "";
        String contactText = "";
        String vmText = "";
        try {
            URL textURL = ClassLoader.getSystemResource("resources/ccitext/readme.txt");
            URL contribURL = ClassLoader.getSystemResource("resources/ccitext/contribution.txt");
            if (textURL != null) {
                gplText = FileTools.streamToString(textURL.openStream());
                contribText = FileTools.streamToString(contribURL.openStream());
                versionText = Version.getInstance().getVersionDateString();
                contactText = Version.getInstance().getContactString();
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        Properties prop = System.getProperties();
        vmText = vmText + this.list("java.version", ":\t\t");
        vmText = vmText + this.list("java.vendor", ":\t\t");
        vmText = vmText + this.list("java.home", ":\t\t");
        vmText = vmText + this.list("java.class.path", ":\t");
        vmText = vmText + this.list("java.library.path", ":\t");
        vmText = vmText + this.list("os.name", ":\t\t");
        vmText = vmText + this.list("os.arch", ":\t\t");
        vmText = vmText + this.list("os.version", ":\t\t");
        vmText = vmText + this.list("user.name", ":\t\t");
        vmText = vmText + this.list("user.home", ":\t\t");
        vmText = vmText + this.list("user.dir", ":\t\t");
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new FlowLayout(1));
        contentPanel.setPreferredSize(new Dimension(x + 10, y + 280));
        this.getContentPane().add(contentPanel);
        JPanel gfxPanel = new JPanel(){

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                g.drawImage(AboutDlg.this.img, 0, 0, this);
            }
        };
        gfxPanel.setPreferredSize(new Dimension(x, y));
        contentPanel.add(gfxPanel);
        String text = JAMS.i18n("Version") + "\t" + versionText + "\n" + JAMS.i18n("Contact") + "\t" + contactText;
        JTextArea versionTextArea = new JTextArea();
        versionTextArea.setBackground(contentPanel.getBackground());
        versionTextArea.setEditable(false);
        versionTextArea.setFont(new Font("SansSerif", 0, 11));
        versionTextArea.setColumns(20);
        versionTextArea.setRows(2);
        versionTextArea.setText(text);
        versionTextArea.setCaretPosition(0);
        versionTextArea.setPreferredSize(new Dimension(x, 30));
        contentPanel.add(versionTextArea);
        JTextArea gplTextArea = new JTextArea();
        gplTextArea.setEditable(false);
        gplTextArea.setFont(new Font("SansSerif", 0, 10));
        gplTextArea.setText(gplText);
        gplTextArea.setCaretPosition(0);
        JScrollPane gplScroll = new JScrollPane(gplTextArea);
        JTextArea contribTextArea = new JTextArea();
        contribTextArea.setEditable(false);
        contribTextArea.setFont(new Font("SansSerif", 0, 10));
        contribTextArea.setText(contribText);
        contribTextArea.setCaretPosition(0);
        JScrollPane contribScroll = new JScrollPane(contribTextArea);
        JTextArea vmTextArea = new JTextArea();
        vmTextArea.setEditable(false);
        vmTextArea.setFont(new Font("SansSerif", 0, 10));
        vmTextArea.setText(vmText);
        vmTextArea.setCaretPosition(0);
        JScrollPane vmScroll = new JScrollPane(vmTextArea);
        JTabbedPane tabPane = new JTabbedPane();
        tabPane.add(JAMS.i18n("Legal_notice"), gplScroll);
        tabPane.add(JAMS.i18n("VM_INFO"), vmScroll);
        tabPane.setPreferredSize(new Dimension(x + 1, 200));
        contentPanel.add(tabPane);
        JButton closeButton = new JButton();
        closeButton.setText(JAMS.i18n("OK"));
        closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AboutDlg.this.dispose();
            }
        });
        closeButton.setPreferredSize(new Dimension(60, 22));
        contentPanel.add(closeButton);
        this.setTitle(JAMS.i18n("About"));
        this.pack();
        Dimension d2 = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(d2.width / 2 - this.getWidth() / 2, d2.height / 2 - this.getHeight() / 2);
    }

    private String list(String key, String space) {
        return key + space + System.getProperty(key) + "\n";
    }
}

